/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalSemaphoreProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;
    public static final int EXTERNALSEMAPHOREFEATURES;

    VkExternalSemaphoreProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalSemaphoreProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalSemaphoreProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalSemaphoreProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkExternalSemaphoreProperties.npNext(this.address());
    }

    @NativeType(value="VkExternalSemaphoreHandleTypeFlags")
    public int exportFromImportedHandleTypes() {
        return VkExternalSemaphoreProperties.nexportFromImportedHandleTypes(this.address());
    }

    @NativeType(value="VkExternalSemaphoreHandleTypeFlags")
    public int compatibleHandleTypes() {
        return VkExternalSemaphoreProperties.ncompatibleHandleTypes(this.address());
    }

    @NativeType(value="VkExternalSemaphoreFeatureFlags")
    public int externalSemaphoreFeatures() {
        return VkExternalSemaphoreProperties.nexternalSemaphoreFeatures(this.address());
    }

    public VkExternalSemaphoreProperties sType(@NativeType(value="VkStructureType") int value) {
        VkExternalSemaphoreProperties.nsType(this.address(), value);
        return this;
    }

    public VkExternalSemaphoreProperties pNext(@NativeType(value="void *") long value) {
        VkExternalSemaphoreProperties.npNext(this.address(), value);
        return this;
    }

    public VkExternalSemaphoreProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkExternalSemaphoreProperties set(VkExternalSemaphoreProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalSemaphoreProperties malloc() {
        return VkExternalSemaphoreProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalSemaphoreProperties calloc() {
        return VkExternalSemaphoreProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalSemaphoreProperties create() {
        return new VkExternalSemaphoreProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalSemaphoreProperties create(long address) {
        return new VkExternalSemaphoreProperties(address, null);
    }

    @Nullable
    public static VkExternalSemaphoreProperties createSafe(long address) {
        return address == 0L ? null : VkExternalSemaphoreProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalSemaphoreProperties.create(VkExternalSemaphoreProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalSemaphoreProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalSemaphoreProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalSemaphoreProperties.create(address, capacity);
    }

    public static VkExternalSemaphoreProperties mallocStack() {
        return VkExternalSemaphoreProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalSemaphoreProperties callocStack() {
        return VkExternalSemaphoreProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalSemaphoreProperties mallocStack(MemoryStack stack) {
        return VkExternalSemaphoreProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalSemaphoreProperties callocStack(MemoryStack stack) {
        return VkExternalSemaphoreProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalSemaphoreProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalSemaphoreProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalSemaphoreProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalSemaphoreProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPATIBLEHANDLETYPES);
    }

    public static int nexternalSemaphoreFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTERNALSEMAPHOREFEATURES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkExternalSemaphoreProperties.__struct(VkExternalSemaphoreProperties.__member(4), VkExternalSemaphoreProperties.__member(POINTER_SIZE), VkExternalSemaphoreProperties.__member(4), VkExternalSemaphoreProperties.__member(4), VkExternalSemaphoreProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(2);
        COMPATIBLEHANDLETYPES = layout.offsetof(3);
        EXTERNALSEMAPHOREFEATURES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkExternalSemaphoreProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalSemaphoreProperties newInstance(long address) {
            return new VkExternalSemaphoreProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalSemaphoreProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkExternalSemaphoreProperties.npNext(this.address());
        }

        @NativeType(value="VkExternalSemaphoreHandleTypeFlags")
        public int exportFromImportedHandleTypes() {
            return VkExternalSemaphoreProperties.nexportFromImportedHandleTypes(this.address());
        }

        @NativeType(value="VkExternalSemaphoreHandleTypeFlags")
        public int compatibleHandleTypes() {
            return VkExternalSemaphoreProperties.ncompatibleHandleTypes(this.address());
        }

        @NativeType(value="VkExternalSemaphoreFeatureFlags")
        public int externalSemaphoreFeatures() {
            return VkExternalSemaphoreProperties.nexternalSemaphoreFeatures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalSemaphoreProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkExternalSemaphoreProperties.npNext(this.address(), value);
            return this;
        }
    }
}

