/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTERNALMEMORYFEATURES;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;

    VkExternalMemoryProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkExternalMemoryFeatureFlags")
    public int externalMemoryFeatures() {
        return VkExternalMemoryProperties.nexternalMemoryFeatures(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int exportFromImportedHandleTypes() {
        return VkExternalMemoryProperties.nexportFromImportedHandleTypes(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int compatibleHandleTypes() {
        return VkExternalMemoryProperties.ncompatibleHandleTypes(this.address());
    }

    public static VkExternalMemoryProperties create(long address) {
        return new VkExternalMemoryProperties(address, null);
    }

    @Nullable
    public static VkExternalMemoryProperties createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryProperties.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryProperties.create(address, capacity);
    }

    public static int nexternalMemoryFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTERNALMEMORYFEATURES);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPATIBLEHANDLETYPES);
    }

    static {
        Struct.Layout layout = VkExternalMemoryProperties.__struct(VkExternalMemoryProperties.__member(4), VkExternalMemoryProperties.__member(4), VkExternalMemoryProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTERNALMEMORYFEATURES = layout.offsetof(0);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(1);
        COMPATIBLEHANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryProperties newInstance(long address) {
            return new VkExternalMemoryProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkExternalMemoryFeatureFlags")
        public int externalMemoryFeatures() {
            return VkExternalMemoryProperties.nexternalMemoryFeatures(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int exportFromImportedHandleTypes() {
            return VkExternalMemoryProperties.nexportFromImportedHandleTypes(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int compatibleHandleTypes() {
            return VkExternalMemoryProperties.ncompatibleHandleTypes(this.address());
        }
    }
}

