/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalBufferProperties;

public class VkExternalBufferPropertiesKHR
extends VkExternalBufferProperties {
    VkExternalBufferPropertiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalBufferPropertiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalBufferPropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkExternalBufferPropertiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalBufferPropertiesKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalBufferPropertiesKHR pNext(@NativeType(value="void *") long value) {
        VkExternalBufferPropertiesKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalBufferPropertiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkExternalBufferPropertiesKHR set(VkExternalBufferPropertiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalBufferPropertiesKHR malloc() {
        return VkExternalBufferPropertiesKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalBufferPropertiesKHR calloc() {
        return VkExternalBufferPropertiesKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalBufferPropertiesKHR create() {
        return new VkExternalBufferPropertiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalBufferPropertiesKHR create(long address) {
        return new VkExternalBufferPropertiesKHR(address, null);
    }

    @Nullable
    public static VkExternalBufferPropertiesKHR createSafe(long address) {
        return address == 0L ? null : VkExternalBufferPropertiesKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalBufferPropertiesKHR.create(VkExternalBufferPropertiesKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalBufferPropertiesKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalBufferPropertiesKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalBufferPropertiesKHR.create(address, capacity);
    }

    public static VkExternalBufferPropertiesKHR mallocStack() {
        return VkExternalBufferPropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferPropertiesKHR callocStack() {
        return VkExternalBufferPropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferPropertiesKHR mallocStack(MemoryStack stack) {
        return VkExternalBufferPropertiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalBufferPropertiesKHR callocStack(MemoryStack stack) {
        return VkExternalBufferPropertiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalBufferPropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalBufferPropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferPropertiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferPropertiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExternalBufferProperties.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalBufferPropertiesKHR newInstance(long address) {
            return new VkExternalBufferPropertiesKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalBufferPropertiesKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkExternalBufferPropertiesKHR.npNext(this.address(), value);
            return this;
        }
    }
}

