/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.SECURITY_ATTRIBUTES;

public class VkExportFenceWin32HandleInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PATTRIBUTES;
    public static final int DWACCESS;
    public static final int NAME;

    VkExportFenceWin32HandleInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExportFenceWin32HandleInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportFenceWin32HandleInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportFenceWin32HandleInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportFenceWin32HandleInfoKHR.npNext(this.address());
    }

    @Nullable
    @NativeType(value="SECURITY_ATTRIBUTES const *")
    public SECURITY_ATTRIBUTES pAttributes() {
        return VkExportFenceWin32HandleInfoKHR.npAttributes(this.address());
    }

    @NativeType(value="DWORD")
    public int dwAccess() {
        return VkExportFenceWin32HandleInfoKHR.ndwAccess(this.address());
    }

    @NativeType(value="LPCWSTR")
    public ByteBuffer name() {
        return VkExportFenceWin32HandleInfoKHR.nname(this.address());
    }

    @NativeType(value="LPCWSTR")
    public String nameString() {
        return VkExportFenceWin32HandleInfoKHR.nnameString(this.address());
    }

    public VkExportFenceWin32HandleInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExportFenceWin32HandleInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkExportFenceWin32HandleInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExportFenceWin32HandleInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkExportFenceWin32HandleInfoKHR pAttributes(@Nullable @NativeType(value="SECURITY_ATTRIBUTES const *") SECURITY_ATTRIBUTES value) {
        VkExportFenceWin32HandleInfoKHR.npAttributes(this.address(), value);
        return this;
    }

    public VkExportFenceWin32HandleInfoKHR dwAccess(@NativeType(value="DWORD") int value) {
        VkExportFenceWin32HandleInfoKHR.ndwAccess(this.address(), value);
        return this;
    }

    public VkExportFenceWin32HandleInfoKHR name(@NativeType(value="LPCWSTR") ByteBuffer value) {
        VkExportFenceWin32HandleInfoKHR.nname(this.address(), value);
        return this;
    }

    public VkExportFenceWin32HandleInfoKHR set(int sType, long pNext, @Nullable SECURITY_ATTRIBUTES pAttributes, int dwAccess, ByteBuffer name) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttributes(pAttributes);
        this.dwAccess(dwAccess);
        this.name(name);
        return this;
    }

    public VkExportFenceWin32HandleInfoKHR set(VkExportFenceWin32HandleInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportFenceWin32HandleInfoKHR malloc() {
        return VkExportFenceWin32HandleInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportFenceWin32HandleInfoKHR calloc() {
        return VkExportFenceWin32HandleInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportFenceWin32HandleInfoKHR create() {
        return new VkExportFenceWin32HandleInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportFenceWin32HandleInfoKHR create(long address) {
        return new VkExportFenceWin32HandleInfoKHR(address, null);
    }

    @Nullable
    public static VkExportFenceWin32HandleInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExportFenceWin32HandleInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportFenceWin32HandleInfoKHR.create(VkExportFenceWin32HandleInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportFenceWin32HandleInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExportFenceWin32HandleInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportFenceWin32HandleInfoKHR.create(address, capacity);
    }

    public static VkExportFenceWin32HandleInfoKHR mallocStack() {
        return VkExportFenceWin32HandleInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportFenceWin32HandleInfoKHR callocStack() {
        return VkExportFenceWin32HandleInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExportFenceWin32HandleInfoKHR mallocStack(MemoryStack stack) {
        return VkExportFenceWin32HandleInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportFenceWin32HandleInfoKHR callocStack(MemoryStack stack) {
        return VkExportFenceWin32HandleInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportFenceWin32HandleInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportFenceWin32HandleInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportFenceWin32HandleInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportFenceWin32HandleInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    @Nullable
    public static SECURITY_ATTRIBUTES npAttributes(long struct) {
        return SECURITY_ATTRIBUTES.createSafe(MemoryUtil.memGetAddress(struct + (long)PATTRIBUTES));
    }

    public static int ndwAccess(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DWACCESS);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npAttributes(long struct, @Nullable SECURITY_ATTRIBUTES value) {
        MemoryUtil.memPutAddress(struct + (long)PATTRIBUTES, MemoryUtil.memAddressSafe(value));
    }

    public static void ndwAccess(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DWACCESS, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        long pAttributes = MemoryUtil.memGetAddress(struct + (long)PATTRIBUTES);
        if (pAttributes != 0L) {
            SECURITY_ATTRIBUTES.validate(pAttributes);
        }
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkExportFenceWin32HandleInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkExportFenceWin32HandleInfoKHR.__struct(VkExportFenceWin32HandleInfoKHR.__member(4), VkExportFenceWin32HandleInfoKHR.__member(POINTER_SIZE), VkExportFenceWin32HandleInfoKHR.__member(POINTER_SIZE), VkExportFenceWin32HandleInfoKHR.__member(4), VkExportFenceWin32HandleInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PATTRIBUTES = layout.offsetof(2);
        DWACCESS = layout.offsetof(3);
        NAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkExportFenceWin32HandleInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportFenceWin32HandleInfoKHR newInstance(long address) {
            return new VkExportFenceWin32HandleInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportFenceWin32HandleInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportFenceWin32HandleInfoKHR.npNext(this.address());
        }

        @Nullable
        @NativeType(value="SECURITY_ATTRIBUTES const *")
        public SECURITY_ATTRIBUTES pAttributes() {
            return VkExportFenceWin32HandleInfoKHR.npAttributes(this.address());
        }

        @NativeType(value="DWORD")
        public int dwAccess() {
            return VkExportFenceWin32HandleInfoKHR.ndwAccess(this.address());
        }

        @NativeType(value="LPCWSTR")
        public ByteBuffer name() {
            return VkExportFenceWin32HandleInfoKHR.nname(this.address());
        }

        @NativeType(value="LPCWSTR")
        public String nameString() {
            return VkExportFenceWin32HandleInfoKHR.nnameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportFenceWin32HandleInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportFenceWin32HandleInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttributes(@Nullable @NativeType(value="SECURITY_ATTRIBUTES const *") SECURITY_ATTRIBUTES value) {
            VkExportFenceWin32HandleInfoKHR.npAttributes(this.address(), value);
            return this;
        }

        public Buffer dwAccess(@NativeType(value="DWORD") int value) {
            VkExportFenceWin32HandleInfoKHR.ndwAccess(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="LPCWSTR") ByteBuffer value) {
            VkExportFenceWin32HandleInfoKHR.nname(this.address(), value);
            return this;
        }
    }
}

