/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkDisplayPropertiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DISPLAY;
    public static final int DISPLAYNAME;
    public static final int PHYSICALDIMENSIONS;
    public static final int PHYSICALRESOLUTION;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int PLANEREORDERPOSSIBLE;
    public static final int PERSISTENTCONTENT;

    VkDisplayPropertiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayPropertiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayPropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDisplayKHR")
    public long display() {
        return VkDisplayPropertiesKHR.ndisplay(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer displayName() {
        return VkDisplayPropertiesKHR.ndisplayName(this.address());
    }

    @NativeType(value="char const *")
    public String displayNameString() {
        return VkDisplayPropertiesKHR.ndisplayNameString(this.address());
    }

    public VkExtent2D physicalDimensions() {
        return VkDisplayPropertiesKHR.nphysicalDimensions(this.address());
    }

    public VkDisplayPropertiesKHR physicalDimensions(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.physicalDimensions());
        return this;
    }

    public VkExtent2D physicalResolution() {
        return VkDisplayPropertiesKHR.nphysicalResolution(this.address());
    }

    public VkDisplayPropertiesKHR physicalResolution(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.physicalResolution());
        return this;
    }

    @NativeType(value="VkSurfaceTransformFlagsKHR")
    public int supportedTransforms() {
        return VkDisplayPropertiesKHR.nsupportedTransforms(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean planeReorderPossible() {
        return VkDisplayPropertiesKHR.nplaneReorderPossible(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean persistentContent() {
        return VkDisplayPropertiesKHR.npersistentContent(this.address()) != 0;
    }

    public static VkDisplayPropertiesKHR malloc() {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayPropertiesKHR calloc() {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayPropertiesKHR create() {
        return new VkDisplayPropertiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayPropertiesKHR create(long address) {
        return new VkDisplayPropertiesKHR(address, null);
    }

    @Nullable
    public static VkDisplayPropertiesKHR createSafe(long address) {
        return address == 0L ? null : VkDisplayPropertiesKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayPropertiesKHR.create(VkDisplayPropertiesKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDisplayPropertiesKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayPropertiesKHR.create(address, capacity);
    }

    public static VkDisplayPropertiesKHR mallocStack() {
        return VkDisplayPropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPropertiesKHR callocStack() {
        return VkDisplayPropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayPropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayPropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DISPLAY);
    }

    public static ByteBuffer ndisplayName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)DISPLAYNAME));
    }

    public static String ndisplayNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)DISPLAYNAME));
    }

    public static VkExtent2D nphysicalDimensions(long struct) {
        return VkExtent2D.create(struct + (long)PHYSICALDIMENSIONS);
    }

    public static VkExtent2D nphysicalResolution(long struct) {
        return VkExtent2D.create(struct + (long)PHYSICALRESOLUTION);
    }

    public static int nsupportedTransforms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int nplaneReorderPossible(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PLANEREORDERPOSSIBLE);
    }

    public static int npersistentContent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PERSISTENTCONTENT);
    }

    static {
        Struct.Layout layout = VkDisplayPropertiesKHR.__struct(VkDisplayPropertiesKHR.__member(8), VkDisplayPropertiesKHR.__member(POINTER_SIZE), VkDisplayPropertiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPropertiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPropertiesKHR.__member(4), VkDisplayPropertiesKHR.__member(4), VkDisplayPropertiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DISPLAY = layout.offsetof(0);
        DISPLAYNAME = layout.offsetof(1);
        PHYSICALDIMENSIONS = layout.offsetof(2);
        PHYSICALRESOLUTION = layout.offsetof(3);
        SUPPORTEDTRANSFORMS = layout.offsetof(4);
        PLANEREORDERPOSSIBLE = layout.offsetof(5);
        PERSISTENTCONTENT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPropertiesKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayPropertiesKHR newInstance(long address) {
            return new VkDisplayPropertiesKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDisplayKHR")
        public long display() {
            return VkDisplayPropertiesKHR.ndisplay(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer displayName() {
            return VkDisplayPropertiesKHR.ndisplayName(this.address());
        }

        @NativeType(value="char const *")
        public String displayNameString() {
            return VkDisplayPropertiesKHR.ndisplayNameString(this.address());
        }

        public VkExtent2D physicalDimensions() {
            return VkDisplayPropertiesKHR.nphysicalDimensions(this.address());
        }

        public Buffer physicalDimensions(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.physicalDimensions());
            return this;
        }

        public VkExtent2D physicalResolution() {
            return VkDisplayPropertiesKHR.nphysicalResolution(this.address());
        }

        public Buffer physicalResolution(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.physicalResolution());
            return this;
        }

        @NativeType(value="VkSurfaceTransformFlagsKHR")
        public int supportedTransforms() {
            return VkDisplayPropertiesKHR.nsupportedTransforms(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean planeReorderPossible() {
            return VkDisplayPropertiesKHR.nplaneReorderPossible(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean persistentContent() {
            return VkDisplayPropertiesKHR.npersistentContent(this.address()) != 0;
        }
    }
}

