/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkDisplayPlaneCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUPPORTEDALPHA;
    public static final int MINSRCPOSITION;
    public static final int MAXSRCPOSITION;
    public static final int MINSRCEXTENT;
    public static final int MAXSRCEXTENT;
    public static final int MINDSTPOSITION;
    public static final int MAXDSTPOSITION;
    public static final int MINDSTEXTENT;
    public static final int MAXDSTEXTENT;

    VkDisplayPlaneCapabilitiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayPlaneCapabilitiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayPlaneCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDisplayPlaneAlphaFlagsKHR")
    public int supportedAlpha() {
        return VkDisplayPlaneCapabilitiesKHR.nsupportedAlpha(this.address());
    }

    public VkOffset2D minSrcPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nminSrcPosition(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR minSrcPosition(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.minSrcPosition());
        return this;
    }

    public VkOffset2D maxSrcPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxSrcPosition(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR maxSrcPosition(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.maxSrcPosition());
        return this;
    }

    public VkExtent2D minSrcExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nminSrcExtent(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR minSrcExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.minSrcExtent());
        return this;
    }

    public VkExtent2D maxSrcExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxSrcExtent(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR maxSrcExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxSrcExtent());
        return this;
    }

    public VkOffset2D minDstPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nminDstPosition(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR minDstPosition(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.minDstPosition());
        return this;
    }

    public VkOffset2D maxDstPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxDstPosition(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR maxDstPosition(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.maxDstPosition());
        return this;
    }

    public VkExtent2D minDstExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nminDstExtent(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR minDstExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.minDstExtent());
        return this;
    }

    public VkExtent2D maxDstExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxDstExtent(this.address());
    }

    public VkDisplayPlaneCapabilitiesKHR maxDstExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxDstExtent());
        return this;
    }

    public static VkDisplayPlaneCapabilitiesKHR malloc() {
        return VkDisplayPlaneCapabilitiesKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayPlaneCapabilitiesKHR calloc() {
        return VkDisplayPlaneCapabilitiesKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayPlaneCapabilitiesKHR create() {
        return new VkDisplayPlaneCapabilitiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayPlaneCapabilitiesKHR create(long address) {
        return new VkDisplayPlaneCapabilitiesKHR(address, null);
    }

    @Nullable
    public static VkDisplayPlaneCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : VkDisplayPlaneCapabilitiesKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayPlaneCapabilitiesKHR.create(VkDisplayPlaneCapabilitiesKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayPlaneCapabilitiesKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDisplayPlaneCapabilitiesKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayPlaneCapabilitiesKHR.create(address, capacity);
    }

    public static VkDisplayPlaneCapabilitiesKHR mallocStack() {
        return VkDisplayPlaneCapabilitiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPlaneCapabilitiesKHR callocStack() {
        return VkDisplayPlaneCapabilitiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPlaneCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPlaneCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayPlaneCapabilitiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayPlaneCapabilitiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsupportedAlpha(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDALPHA);
    }

    public static VkOffset2D nminSrcPosition(long struct) {
        return VkOffset2D.create(struct + (long)MINSRCPOSITION);
    }

    public static VkOffset2D nmaxSrcPosition(long struct) {
        return VkOffset2D.create(struct + (long)MAXSRCPOSITION);
    }

    public static VkExtent2D nminSrcExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINSRCEXTENT);
    }

    public static VkExtent2D nmaxSrcExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXSRCEXTENT);
    }

    public static VkOffset2D nminDstPosition(long struct) {
        return VkOffset2D.create(struct + (long)MINDSTPOSITION);
    }

    public static VkOffset2D nmaxDstPosition(long struct) {
        return VkOffset2D.create(struct + (long)MAXDSTPOSITION);
    }

    public static VkExtent2D nminDstExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINDSTEXTENT);
    }

    public static VkExtent2D nmaxDstExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXDSTEXTENT);
    }

    static {
        Struct.Layout layout = VkDisplayPlaneCapabilitiesKHR.__struct(VkDisplayPlaneCapabilitiesKHR.__member(4), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUPPORTEDALPHA = layout.offsetof(0);
        MINSRCPOSITION = layout.offsetof(1);
        MAXSRCPOSITION = layout.offsetof(2);
        MINSRCEXTENT = layout.offsetof(3);
        MAXSRCEXTENT = layout.offsetof(4);
        MINDSTPOSITION = layout.offsetof(5);
        MAXDSTPOSITION = layout.offsetof(6);
        MINDSTEXTENT = layout.offsetof(7);
        MAXDSTEXTENT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPlaneCapabilitiesKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayPlaneCapabilitiesKHR newInstance(long address) {
            return new VkDisplayPlaneCapabilitiesKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDisplayPlaneAlphaFlagsKHR")
        public int supportedAlpha() {
            return VkDisplayPlaneCapabilitiesKHR.nsupportedAlpha(this.address());
        }

        public VkOffset2D minSrcPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nminSrcPosition(this.address());
        }

        public Buffer minSrcPosition(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.minSrcPosition());
            return this;
        }

        public VkOffset2D maxSrcPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxSrcPosition(this.address());
        }

        public Buffer maxSrcPosition(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.maxSrcPosition());
            return this;
        }

        public VkExtent2D minSrcExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nminSrcExtent(this.address());
        }

        public Buffer minSrcExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.minSrcExtent());
            return this;
        }

        public VkExtent2D maxSrcExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxSrcExtent(this.address());
        }

        public Buffer maxSrcExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxSrcExtent());
            return this;
        }

        public VkOffset2D minDstPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nminDstPosition(this.address());
        }

        public Buffer minDstPosition(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.minDstPosition());
            return this;
        }

        public VkOffset2D maxDstPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxDstPosition(this.address());
        }

        public Buffer maxDstPosition(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.maxDstPosition());
            return this;
        }

        public VkExtent2D minDstExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nminDstExtent(this.address());
        }

        public Buffer minDstExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.minDstExtent());
            return this;
        }

        public VkExtent2D maxDstExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxDstExtent(this.address());
        }

        public Buffer maxDstExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxDstExtent());
            return this;
        }
    }
}

