/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDisplayEventInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DISPLAYEVENT;

    VkDisplayEventInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayEventInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayEventInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplayEventInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplayEventInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDisplayEventTypeEXT")
    public int displayEvent() {
        return VkDisplayEventInfoEXT.ndisplayEvent(this.address());
    }

    public VkDisplayEventInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDisplayEventInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDisplayEventInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDisplayEventInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDisplayEventInfoEXT displayEvent(@NativeType(value="VkDisplayEventTypeEXT") int value) {
        VkDisplayEventInfoEXT.ndisplayEvent(this.address(), value);
        return this;
    }

    public VkDisplayEventInfoEXT set(int sType, long pNext, int displayEvent) {
        this.sType(sType);
        this.pNext(pNext);
        this.displayEvent(displayEvent);
        return this;
    }

    public VkDisplayEventInfoEXT set(VkDisplayEventInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDisplayEventInfoEXT malloc() {
        return VkDisplayEventInfoEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayEventInfoEXT calloc() {
        return VkDisplayEventInfoEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayEventInfoEXT create() {
        return new VkDisplayEventInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayEventInfoEXT create(long address) {
        return new VkDisplayEventInfoEXT(address, null);
    }

    @Nullable
    public static VkDisplayEventInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDisplayEventInfoEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayEventInfoEXT.create(VkDisplayEventInfoEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayEventInfoEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDisplayEventInfoEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayEventInfoEXT.create(address, capacity);
    }

    public static VkDisplayEventInfoEXT mallocStack() {
        return VkDisplayEventInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayEventInfoEXT callocStack() {
        return VkDisplayEventInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayEventInfoEXT mallocStack(MemoryStack stack) {
        return VkDisplayEventInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayEventInfoEXT callocStack(MemoryStack stack) {
        return VkDisplayEventInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayEventInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayEventInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayEventInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayEventInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndisplayEvent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DISPLAYEVENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndisplayEvent(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DISPLAYEVENT, value);
    }

    static {
        Struct.Layout layout = VkDisplayEventInfoEXT.__struct(VkDisplayEventInfoEXT.__member(4), VkDisplayEventInfoEXT.__member(POINTER_SIZE), VkDisplayEventInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DISPLAYEVENT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayEventInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayEventInfoEXT newInstance(long address) {
            return new VkDisplayEventInfoEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplayEventInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplayEventInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDisplayEventTypeEXT")
        public int displayEvent() {
            return VkDisplayEventInfoEXT.ndisplayEvent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplayEventInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplayEventInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer displayEvent(@NativeType(value="VkDisplayEventTypeEXT") int value) {
            VkDisplayEventInfoEXT.ndisplayEvent(this.address(), value);
            return this;
        }
    }
}

