/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDeviceGroupRenderPassBeginInfo;
import org.lwjgl.vulkan.VkRect2D;

public class VkDeviceGroupRenderPassBeginInfoKHR
extends VkDeviceGroupRenderPassBeginInfo {
    VkDeviceGroupRenderPassBeginInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupRenderPassBeginInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupRenderPassBeginInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkDeviceGroupRenderPassBeginInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupRenderPassBeginInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupRenderPassBeginInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupRenderPassBeginInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupRenderPassBeginInfoKHR deviceMask(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupRenderPassBeginInfoKHR.ndeviceMask(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupRenderPassBeginInfoKHR pDeviceRenderAreas(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
        VkDeviceGroupRenderPassBeginInfoKHR.npDeviceRenderAreas(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupRenderPassBeginInfoKHR set(int sType, long pNext, int deviceMask, @Nullable VkRect2D.Buffer pDeviceRenderAreas) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceMask(deviceMask);
        this.pDeviceRenderAreas(pDeviceRenderAreas);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfoKHR set(VkDeviceGroupRenderPassBeginInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR malloc() {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR calloc() {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR create() {
        return new VkDeviceGroupRenderPassBeginInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR create(long address) {
        return new VkDeviceGroupRenderPassBeginInfoKHR(address, null);
    }

    @Nullable
    public static VkDeviceGroupRenderPassBeginInfoKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupRenderPassBeginInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(VkDeviceGroupRenderPassBeginInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupRenderPassBeginInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupRenderPassBeginInfoKHR.create(address, capacity);
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR mallocStack() {
        return VkDeviceGroupRenderPassBeginInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR callocStack() {
        return VkDeviceGroupRenderPassBeginInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDeviceGroupRenderPassBeginInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupRenderPassBeginInfoKHR newInstance(long address) {
            return new VkDeviceGroupRenderPassBeginInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupRenderPassBeginInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupRenderPassBeginInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupRenderPassBeginInfoKHR.ndeviceMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer pDeviceRenderAreas(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
            VkDeviceGroupRenderPassBeginInfoKHR.npDeviceRenderAreas(this.address(), value);
            return this;
        }
    }
}

