/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDeviceGroupRenderPassBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEMASK;
    public static final int DEVICERENDERAREACOUNT;
    public static final int PDEVICERENDERAREAS;

    VkDeviceGroupRenderPassBeginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupRenderPassBeginInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupRenderPassBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupRenderPassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupRenderPassBeginInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceRenderAreaCount() {
        return VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRect2D const *")
    public VkRect2D.Buffer pDeviceRenderAreas() {
        return VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address());
    }

    public VkDeviceGroupRenderPassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupRenderPassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupRenderPassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo pDeviceRenderAreas(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
        VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo set(int sType, long pNext, int deviceMask, @Nullable VkRect2D.Buffer pDeviceRenderAreas) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceMask(deviceMask);
        this.pDeviceRenderAreas(pDeviceRenderAreas);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo set(VkDeviceGroupRenderPassBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupRenderPassBeginInfo malloc() {
        return VkDeviceGroupRenderPassBeginInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo calloc() {
        return VkDeviceGroupRenderPassBeginInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo create() {
        return new VkDeviceGroupRenderPassBeginInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo create(long address) {
        return new VkDeviceGroupRenderPassBeginInfo(address, null);
    }

    @Nullable
    public static VkDeviceGroupRenderPassBeginInfo createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupRenderPassBeginInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.create(VkDeviceGroupRenderPassBeginInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupRenderPassBeginInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupRenderPassBeginInfo.create(address, capacity);
    }

    public static VkDeviceGroupRenderPassBeginInfo mallocStack() {
        return VkDeviceGroupRenderPassBeginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupRenderPassBeginInfo callocStack() {
        return VkDeviceGroupRenderPassBeginInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupRenderPassBeginInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMASK);
    }

    public static int ndeviceRenderAreaCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICERENDERAREACOUNT);
    }

    @Nullable
    public static VkRect2D.Buffer npDeviceRenderAreas(long struct) {
        return VkRect2D.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEVICERENDERAREAS), VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEMASK, value);
    }

    public static void ndeviceRenderAreaCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICERENDERAREACOUNT, value);
    }

    public static void npDeviceRenderAreas(long struct, @Nullable VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICERENDERAREAS, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICERENDERAREAS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupRenderPassBeginInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupRenderPassBeginInfo.__struct(VkDeviceGroupRenderPassBeginInfo.__member(4), VkDeviceGroupRenderPassBeginInfo.__member(POINTER_SIZE), VkDeviceGroupRenderPassBeginInfo.__member(4), VkDeviceGroupRenderPassBeginInfo.__member(4), VkDeviceGroupRenderPassBeginInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEMASK = layout.offsetof(2);
        DEVICERENDERAREACOUNT = layout.offsetof(3);
        PDEVICERENDERAREAS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupRenderPassBeginInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupRenderPassBeginInfo newInstance(long address) {
            return new VkDeviceGroupRenderPassBeginInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupRenderPassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupRenderPassBeginInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceRenderAreaCount() {
            return VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRect2D const *")
        public VkRect2D.Buffer pDeviceRenderAreas() {
            return VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupRenderPassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupRenderPassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address(), value);
            return this;
        }

        public Buffer pDeviceRenderAreas(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
            VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address(), value);
            return this;
        }
    }
}

