/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupPresentInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SWAPCHAINCOUNT;
    public static final int PDEVICEMASKS;
    public static final int MODE;

    VkDeviceGroupPresentInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupPresentInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupPresentInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupPresentInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupPresentInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int swapchainCount() {
        return VkDeviceGroupPresentInfoKHR.nswapchainCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pDeviceMasks() {
        return VkDeviceGroupPresentInfoKHR.npDeviceMasks(this.address());
    }

    @NativeType(value="VkDeviceGroupPresentModeFlagBitsKHR")
    public int mode() {
        return VkDeviceGroupPresentInfoKHR.nmode(this.address());
    }

    public VkDeviceGroupPresentInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHR pDeviceMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkDeviceGroupPresentInfoKHR.npDeviceMasks(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHR mode(@NativeType(value="VkDeviceGroupPresentModeFlagBitsKHR") int value) {
        VkDeviceGroupPresentInfoKHR.nmode(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHR set(int sType, long pNext, @Nullable IntBuffer pDeviceMasks, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceMasks(pDeviceMasks);
        this.mode(mode);
        return this;
    }

    public VkDeviceGroupPresentInfoKHR set(VkDeviceGroupPresentInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupPresentInfoKHR malloc() {
        return VkDeviceGroupPresentInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHR calloc() {
        return VkDeviceGroupPresentInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHR create() {
        return new VkDeviceGroupPresentInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHR create(long address) {
        return new VkDeviceGroupPresentInfoKHR(address, null);
    }

    @Nullable
    public static VkDeviceGroupPresentInfoKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupPresentInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupPresentInfoKHR.create(VkDeviceGroupPresentInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupPresentInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupPresentInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupPresentInfoKHR.create(address, capacity);
    }

    public static VkDeviceGroupPresentInfoKHR mallocStack() {
        return VkDeviceGroupPresentInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentInfoKHR callocStack() {
        return VkDeviceGroupPresentInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentInfoKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupPresentInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupPresentInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nswapchainCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SWAPCHAINCOUNT);
    }

    @Nullable
    public static IntBuffer npDeviceMasks(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDEVICEMASKS), VkDeviceGroupPresentInfoKHR.nswapchainCount(struct));
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nswapchainCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SWAPCHAINCOUNT, value);
    }

    public static void npDeviceMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEMASKS, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupPresentInfoKHR.nswapchainCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MODE, value);
    }

    public static void validate(long struct) {
        if (VkDeviceGroupPresentInfoKHR.nswapchainCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICEMASKS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupPresentInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupPresentInfoKHR.__struct(VkDeviceGroupPresentInfoKHR.__member(4), VkDeviceGroupPresentInfoKHR.__member(POINTER_SIZE), VkDeviceGroupPresentInfoKHR.__member(4), VkDeviceGroupPresentInfoKHR.__member(POINTER_SIZE), VkDeviceGroupPresentInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SWAPCHAINCOUNT = layout.offsetof(2);
        PDEVICEMASKS = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupPresentInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupPresentInfoKHR newInstance(long address) {
            return new VkDeviceGroupPresentInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupPresentInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupPresentInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int swapchainCount() {
            return VkDeviceGroupPresentInfoKHR.nswapchainCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pDeviceMasks() {
            return VkDeviceGroupPresentInfoKHR.npDeviceMasks(this.address());
        }

        @NativeType(value="VkDeviceGroupPresentModeFlagBitsKHR")
        public int mode() {
            return VkDeviceGroupPresentInfoKHR.nmode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pDeviceMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkDeviceGroupPresentInfoKHR.npDeviceMasks(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkDeviceGroupPresentModeFlagBitsKHR") int value) {
            VkDeviceGroupPresentInfoKHR.nmode(this.address(), value);
            return this;
        }
    }
}

