/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDeviceGroupBindSparseInfo;

public class VkDeviceGroupBindSparseInfoKHR
extends VkDeviceGroupBindSparseInfo {
    VkDeviceGroupBindSparseInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupBindSparseInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupBindSparseInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupBindSparseInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupBindSparseInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfoKHR.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfoKHR.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHR set(VkDeviceGroupBindSparseInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfoKHR malloc() {
        return VkDeviceGroupBindSparseInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR calloc() {
        return VkDeviceGroupBindSparseInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR create() {
        return new VkDeviceGroupBindSparseInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR create(long address) {
        return new VkDeviceGroupBindSparseInfoKHR(address, null);
    }

    @Nullable
    public static VkDeviceGroupBindSparseInfoKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupBindSparseInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.create(VkDeviceGroupBindSparseInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupBindSparseInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupBindSparseInfoKHR.create(address, capacity);
    }

    public static VkDeviceGroupBindSparseInfoKHR mallocStack() {
        return VkDeviceGroupBindSparseInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfoKHR callocStack() {
        return VkDeviceGroupBindSparseInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfoKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDeviceGroupBindSparseInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupBindSparseInfoKHR newInstance(long address) {
            return new VkDeviceGroupBindSparseInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupBindSparseInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupBindSparseInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfoKHR.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfoKHR.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

