/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupBindSparseInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RESOURCEDEVICEINDEX;
    public static final int MEMORYDEVICEINDEX;

    VkDeviceGroupBindSparseInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupBindSparseInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupBindSparseInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupBindSparseInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupBindSparseInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int resourceDeviceIndex() {
        return VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryDeviceIndex() {
        return VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address());
    }

    public VkDeviceGroupBindSparseInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupBindSparseInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupBindSparseInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfo set(VkDeviceGroupBindSparseInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfo malloc() {
        return VkDeviceGroupBindSparseInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfo calloc() {
        return VkDeviceGroupBindSparseInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfo create() {
        return new VkDeviceGroupBindSparseInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfo create(long address) {
        return new VkDeviceGroupBindSparseInfo(address, null);
    }

    @Nullable
    public static VkDeviceGroupBindSparseInfo createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupBindSparseInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupBindSparseInfo.create(VkDeviceGroupBindSparseInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupBindSparseInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupBindSparseInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupBindSparseInfo.create(address, capacity);
    }

    public static VkDeviceGroupBindSparseInfo mallocStack() {
        return VkDeviceGroupBindSparseInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfo callocStack() {
        return VkDeviceGroupBindSparseInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nresourceDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESOURCEDEVICEINDEX);
    }

    public static int nmemoryDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYDEVICEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nresourceDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESOURCEDEVICEINDEX, value);
    }

    public static void nmemoryDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYDEVICEINDEX, value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupBindSparseInfo.__struct(VkDeviceGroupBindSparseInfo.__member(4), VkDeviceGroupBindSparseInfo.__member(POINTER_SIZE), VkDeviceGroupBindSparseInfo.__member(4), VkDeviceGroupBindSparseInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RESOURCEDEVICEINDEX = layout.offsetof(2);
        MEMORYDEVICEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupBindSparseInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupBindSparseInfo newInstance(long address) {
            return new VkDeviceGroupBindSparseInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupBindSparseInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupBindSparseInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int resourceDeviceIndex() {
            return VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryDeviceIndex() {
            return VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupBindSparseInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupBindSparseInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        public Buffer memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

