/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBinding;

public class VkDescriptorSetLayoutCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BINDINGCOUNT;
    public static final int PBINDINGS;

    VkDescriptorSetLayoutCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorSetLayoutCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorSetLayoutCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorSetLayoutCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSetLayoutCreateFlags")
    public int flags() {
        return VkDescriptorSetLayoutCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindingCount() {
        return VkDescriptorSetLayoutCreateInfo.nbindingCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorSetLayoutBinding const *")
    public VkDescriptorSetLayoutBinding.Buffer pBindings() {
        return VkDescriptorSetLayoutCreateInfo.npBindings(this.address());
    }

    public VkDescriptorSetLayoutCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDescriptorSetLayoutCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo flags(@NativeType(value="VkDescriptorSetLayoutCreateFlags") int value) {
        VkDescriptorSetLayoutCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo pBindings(@Nullable @NativeType(value="VkDescriptorSetLayoutBinding const *") VkDescriptorSetLayoutBinding.Buffer value) {
        VkDescriptorSetLayoutCreateInfo.npBindings(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo set(int sType, long pNext, int flags, @Nullable VkDescriptorSetLayoutBinding.Buffer pBindings) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pBindings(pBindings);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo set(VkDescriptorSetLayoutCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutCreateInfo malloc() {
        return VkDescriptorSetLayoutCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo calloc() {
        return VkDescriptorSetLayoutCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo create() {
        return new VkDescriptorSetLayoutCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo create(long address) {
        return new VkDescriptorSetLayoutCreateInfo(address, null);
    }

    @Nullable
    public static VkDescriptorSetLayoutCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDescriptorSetLayoutCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.create(VkDescriptorSetLayoutCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorSetLayoutCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorSetLayoutCreateInfo.create(address, capacity);
    }

    public static VkDescriptorSetLayoutCreateInfo mallocStack() {
        return VkDescriptorSetLayoutCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutCreateInfo callocStack() {
        return VkDescriptorSetLayoutCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutCreateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutCreateInfo callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nbindingCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDINGCOUNT);
    }

    @Nullable
    public static VkDescriptorSetLayoutBinding.Buffer npBindings(long struct) {
        return VkDescriptorSetLayoutBinding.createSafe(MemoryUtil.memGetAddress(struct + (long)PBINDINGS), VkDescriptorSetLayoutCreateInfo.nbindingCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nbindingCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDINGCOUNT, value);
    }

    public static void npBindings(long struct, @Nullable VkDescriptorSetLayoutBinding.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDINGS, MemoryUtil.memAddressSafe(value));
        VkDescriptorSetLayoutCreateInfo.nbindingCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDescriptorSetLayoutCreateInfo.nbindingCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDINGS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDescriptorSetLayoutCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutCreateInfo.__struct(VkDescriptorSetLayoutCreateInfo.__member(4), VkDescriptorSetLayoutCreateInfo.__member(POINTER_SIZE), VkDescriptorSetLayoutCreateInfo.__member(4), VkDescriptorSetLayoutCreateInfo.__member(4), VkDescriptorSetLayoutCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BINDINGCOUNT = layout.offsetof(3);
        PBINDINGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorSetLayoutCreateInfo newInstance(long address) {
            return new VkDescriptorSetLayoutCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorSetLayoutCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSetLayoutCreateFlags")
        public int flags() {
            return VkDescriptorSetLayoutCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindingCount() {
            return VkDescriptorSetLayoutCreateInfo.nbindingCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorSetLayoutBinding const *")
        public VkDescriptorSetLayoutBinding.Buffer pBindings() {
            return VkDescriptorSetLayoutCreateInfo.npBindings(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorSetLayoutCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDescriptorSetLayoutCreateFlags") int value) {
            VkDescriptorSetLayoutCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pBindings(@Nullable @NativeType(value="VkDescriptorSetLayoutBinding const *") VkDescriptorSetLayoutBinding.Buffer value) {
            VkDescriptorSetLayoutCreateInfo.npBindings(this.address(), value);
            return this;
        }
    }
}

