/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDebugUtilsLabelEXT;
import org.lwjgl.vulkan.VkDebugUtilsObjectNameInfoEXT;

public class VkDebugUtilsMessengerCallbackDataEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PMESSAGEIDNAME;
    public static final int MESSAGEIDNUMBER;
    public static final int PMESSAGE;
    public static final int QUEUELABELCOUNT;
    public static final int PQUEUELABELS;
    public static final int CMDBUFLABELCOUNT;
    public static final int PCMDBUFLABELS;
    public static final int OBJECTCOUNT;
    public static final int POBJECTS;

    VkDebugUtilsMessengerCallbackDataEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDebugUtilsMessengerCallbackDataEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugUtilsMessengerCallbackDataEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT")
    public int flags() {
        return VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pMessageIdName() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pMessageIdNameString() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdNameString(this.address());
    }

    @NativeType(value="int32_t")
    public int messageIdNumber() {
        return VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pMessage() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address());
    }

    @NativeType(value="char const *")
    public String pMessageString() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessageString(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueLabelCount() {
        return VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDebugUtilsLabelEXT *")
    public VkDebugUtilsLabelEXT.Buffer pQueueLabels() {
        return VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address());
    }

    @NativeType(value="uint32_t")
    public int cmdBufLabelCount() {
        return VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDebugUtilsLabelEXT *")
    public VkDebugUtilsLabelEXT.Buffer pCmdBufLabels() {
        return VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address());
    }

    @NativeType(value="uint32_t")
    public int objectCount() {
        return VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address());
    }

    @NativeType(value="VkDebugUtilsObjectNameInfoEXT *")
    public VkDebugUtilsObjectNameInfoEXT.Buffer pObjects() {
        return VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address());
    }

    public VkDebugUtilsMessengerCallbackDataEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT flags(@NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pMessageIdName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT messageIdNumber(@NativeType(value="int32_t") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pMessage(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT queueLabelCount(@NativeType(value="uint32_t") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pQueueLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT *") VkDebugUtilsLabelEXT.Buffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT cmdBufLabelCount(@NativeType(value="uint32_t") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pCmdBufLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT *") VkDebugUtilsLabelEXT.Buffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pObjects(@NativeType(value="VkDebugUtilsObjectNameInfoEXT *") VkDebugUtilsObjectNameInfoEXT.Buffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT set(int sType, long pNext, int flags, @Nullable ByteBuffer pMessageIdName, int messageIdNumber, ByteBuffer pMessage, int queueLabelCount, @Nullable VkDebugUtilsLabelEXT.Buffer pQueueLabels, int cmdBufLabelCount, @Nullable VkDebugUtilsLabelEXT.Buffer pCmdBufLabels, VkDebugUtilsObjectNameInfoEXT.Buffer pObjects) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pMessageIdName(pMessageIdName);
        this.messageIdNumber(messageIdNumber);
        this.pMessage(pMessage);
        this.queueLabelCount(queueLabelCount);
        this.pQueueLabels(pQueueLabels);
        this.cmdBufLabelCount(cmdBufLabelCount);
        this.pCmdBufLabels(pCmdBufLabels);
        this.pObjects(pObjects);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT set(VkDebugUtilsMessengerCallbackDataEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugUtilsMessengerCallbackDataEXT malloc() {
        return VkDebugUtilsMessengerCallbackDataEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDebugUtilsMessengerCallbackDataEXT calloc() {
        return VkDebugUtilsMessengerCallbackDataEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDebugUtilsMessengerCallbackDataEXT create() {
        return new VkDebugUtilsMessengerCallbackDataEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugUtilsMessengerCallbackDataEXT create(long address) {
        return new VkDebugUtilsMessengerCallbackDataEXT(address, null);
    }

    @Nullable
    public static VkDebugUtilsMessengerCallbackDataEXT createSafe(long address) {
        return address == 0L ? null : VkDebugUtilsMessengerCallbackDataEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugUtilsMessengerCallbackDataEXT.create(VkDebugUtilsMessengerCallbackDataEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugUtilsMessengerCallbackDataEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDebugUtilsMessengerCallbackDataEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDebugUtilsMessengerCallbackDataEXT.create(address, capacity);
    }

    public static VkDebugUtilsMessengerCallbackDataEXT mallocStack() {
        return VkDebugUtilsMessengerCallbackDataEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsMessengerCallbackDataEXT callocStack() {
        return VkDebugUtilsMessengerCallbackDataEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsMessengerCallbackDataEXT mallocStack(MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugUtilsMessengerCallbackDataEXT callocStack(MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsMessengerCallbackDataEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsMessengerCallbackDataEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    @Nullable
    public static ByteBuffer npMessageIdName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)PMESSAGEIDNAME));
    }

    @Nullable
    public static String npMessageIdNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)PMESSAGEIDNAME));
    }

    public static int nmessageIdNumber(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MESSAGEIDNUMBER);
    }

    public static ByteBuffer npMessage(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PMESSAGE));
    }

    public static String npMessageString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PMESSAGE));
    }

    public static int nqueueLabelCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUELABELCOUNT);
    }

    @Nullable
    public static VkDebugUtilsLabelEXT.Buffer npQueueLabels(long struct) {
        return VkDebugUtilsLabelEXT.createSafe(MemoryUtil.memGetAddress(struct + (long)PQUEUELABELS), VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(struct));
    }

    public static int ncmdBufLabelCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CMDBUFLABELCOUNT);
    }

    @Nullable
    public static VkDebugUtilsLabelEXT.Buffer npCmdBufLabels(long struct) {
        return VkDebugUtilsLabelEXT.createSafe(MemoryUtil.memGetAddress(struct + (long)PCMDBUFLABELS), VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(struct));
    }

    public static int nobjectCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTCOUNT);
    }

    public static VkDebugUtilsObjectNameInfoEXT.Buffer npObjects(long struct) {
        return VkDebugUtilsObjectNameInfoEXT.create(MemoryUtil.memGetAddress(struct + (long)POBJECTS), VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npMessageIdName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PMESSAGEIDNAME, MemoryUtil.memAddressSafe(value));
    }

    public static void nmessageIdNumber(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MESSAGEIDNUMBER, value);
    }

    public static void npMessage(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PMESSAGE, MemoryUtil.memAddress(value));
    }

    public static void nqueueLabelCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUELABELCOUNT, value);
    }

    public static void npQueueLabels(long struct, @Nullable VkDebugUtilsLabelEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUELABELS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(struct, value.remaining());
        }
    }

    public static void ncmdBufLabelCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CMDBUFLABELCOUNT, value);
    }

    public static void npCmdBufLabels(long struct, @Nullable VkDebugUtilsLabelEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCMDBUFLABELS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(struct, value.remaining());
        }
    }

    public static void nobjectCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTCOUNT, value);
    }

    public static void npObjects(long struct, VkDebugUtilsObjectNameInfoEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)POBJECTS, value.address());
        VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PMESSAGE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POBJECTS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugUtilsMessengerCallbackDataEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugUtilsMessengerCallbackDataEXT.__struct(VkDebugUtilsMessengerCallbackDataEXT.__member(4), VkDebugUtilsMessengerCallbackDataEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member(4), VkDebugUtilsMessengerCallbackDataEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member(4), VkDebugUtilsMessengerCallbackDataEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member(4), VkDebugUtilsMessengerCallbackDataEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member(4), VkDebugUtilsMessengerCallbackDataEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member(4), VkDebugUtilsMessengerCallbackDataEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PMESSAGEIDNAME = layout.offsetof(3);
        MESSAGEIDNUMBER = layout.offsetof(4);
        PMESSAGE = layout.offsetof(5);
        QUEUELABELCOUNT = layout.offsetof(6);
        PQUEUELABELS = layout.offsetof(7);
        CMDBUFLABELCOUNT = layout.offsetof(8);
        PCMDBUFLABELS = layout.offsetof(9);
        OBJECTCOUNT = layout.offsetof(10);
        POBJECTS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsMessengerCallbackDataEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugUtilsMessengerCallbackDataEXT newInstance(long address) {
            return new VkDebugUtilsMessengerCallbackDataEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT")
        public int flags() {
            return VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pMessageIdName() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pMessageIdNameString() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdNameString(this.address());
        }

        @NativeType(value="int32_t")
        public int messageIdNumber() {
            return VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pMessage() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address());
        }

        @NativeType(value="char const *")
        public String pMessageString() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessageString(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueLabelCount() {
            return VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDebugUtilsLabelEXT *")
        public VkDebugUtilsLabelEXT.Buffer pQueueLabels() {
            return VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address());
        }

        @NativeType(value="uint32_t")
        public int cmdBufLabelCount() {
            return VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDebugUtilsLabelEXT *")
        public VkDebugUtilsLabelEXT.Buffer pCmdBufLabels() {
            return VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address());
        }

        @NativeType(value="uint32_t")
        public int objectCount() {
            return VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address());
        }

        @NativeType(value="VkDebugUtilsObjectNameInfoEXT *")
        public VkDebugUtilsObjectNameInfoEXT.Buffer pObjects() {
            return VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer pMessageIdName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address(), value);
            return this;
        }

        public Buffer messageIdNumber(@NativeType(value="int32_t") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address(), value);
            return this;
        }

        public Buffer pMessage(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address(), value);
            return this;
        }

        public Buffer queueLabelCount(@NativeType(value="uint32_t") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(this.address(), value);
            return this;
        }

        public Buffer pQueueLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT *") VkDebugUtilsLabelEXT.Buffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address(), value);
            return this;
        }

        public Buffer cmdBufLabelCount(@NativeType(value="uint32_t") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(this.address(), value);
            return this;
        }

        public Buffer pCmdBufLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT *") VkDebugUtilsLabelEXT.Buffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address(), value);
            return this;
        }

        public Buffer pObjects(@NativeType(value="VkDebugUtilsObjectNameInfoEXT *") VkDebugUtilsObjectNameInfoEXT.Buffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address(), value);
            return this;
        }
    }
}

