/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerMarkerInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PMARKERNAME;
    public static final int COLOR;

    VkDebugMarkerMarkerInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDebugMarkerMarkerInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugMarkerMarkerInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugMarkerMarkerInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugMarkerMarkerInfoEXT.npNext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pMarkerName() {
        return VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address());
    }

    @NativeType(value="char const *")
    public String pMarkerNameString() {
        return VkDebugMarkerMarkerInfoEXT.npMarkerNameString(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer color() {
        return VkDebugMarkerMarkerInfoEXT.ncolor(this.address());
    }

    public float color(int index) {
        return VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index);
    }

    public VkDebugMarkerMarkerInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugMarkerMarkerInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugMarkerMarkerInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT pMarkerName(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT color(@NativeType(value="float[4]") FloatBuffer value) {
        VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT color(int index, float value) {
        VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index, value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT set(int sType, long pNext, ByteBuffer pMarkerName, FloatBuffer color) {
        this.sType(sType);
        this.pNext(pNext);
        this.pMarkerName(pMarkerName);
        this.color(color);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT set(VkDebugMarkerMarkerInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugMarkerMarkerInfoEXT malloc() {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT calloc() {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT create() {
        return new VkDebugMarkerMarkerInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT create(long address) {
        return new VkDebugMarkerMarkerInfoEXT(address, null);
    }

    @Nullable
    public static VkDebugMarkerMarkerInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDebugMarkerMarkerInfoEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.create(VkDebugMarkerMarkerInfoEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDebugMarkerMarkerInfoEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDebugMarkerMarkerInfoEXT.create(address, capacity);
    }

    public static VkDebugMarkerMarkerInfoEXT mallocStack() {
        return VkDebugMarkerMarkerInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerMarkerInfoEXT callocStack() {
        return VkDebugMarkerMarkerInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerMarkerInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer npMarkerName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static String npMarkerNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static FloatBuffer ncolor(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)COLOR, 4);
    }

    public static float ncolor(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR + Checks.check(index, 4) * 4L);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npMarkerName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PMARKERNAME, MemoryUtil.memAddress(value));
    }

    public static void ncolor(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLOR, value.remaining() * 4);
    }

    public static void ncolor(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR + Checks.check(index, 4) * 4L, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugMarkerMarkerInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugMarkerMarkerInfoEXT.__struct(VkDebugMarkerMarkerInfoEXT.__member(4), VkDebugMarkerMarkerInfoEXT.__member(POINTER_SIZE), VkDebugMarkerMarkerInfoEXT.__member(POINTER_SIZE), VkDebugMarkerMarkerInfoEXT.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PMARKERNAME = layout.offsetof(2);
        COLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerMarkerInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugMarkerMarkerInfoEXT newInstance(long address) {
            return new VkDebugMarkerMarkerInfoEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugMarkerMarkerInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugMarkerMarkerInfoEXT.npNext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pMarkerName() {
            return VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address());
        }

        @NativeType(value="char const *")
        public String pMarkerNameString() {
            return VkDebugMarkerMarkerInfoEXT.npMarkerNameString(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer color() {
            return VkDebugMarkerMarkerInfoEXT.ncolor(this.address());
        }

        public float color(int index) {
            return VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugMarkerMarkerInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugMarkerMarkerInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pMarkerName(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address(), value);
            return this;
        }

        public Buffer color(@NativeType(value="float[4]") FloatBuffer value) {
            VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(int index, float value) {
            VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index, value);
            return this;
        }
    }
}

