/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandBufferInheritanceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RENDERPASS;
    public static final int SUBPASS;
    public static final int FRAMEBUFFER;
    public static final int OCCLUSIONQUERYENABLE;
    public static final int QUERYFLAGS;
    public static final int PIPELINESTATISTICS;

    VkCommandBufferInheritanceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkCommandBufferInheritanceInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCommandBufferInheritanceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandBufferInheritanceInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandBufferInheritanceInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkCommandBufferInheritanceInfo.nrenderPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkCommandBufferInheritanceInfo.nsubpass(this.address());
    }

    @NativeType(value="VkFramebuffer")
    public long framebuffer() {
        return VkCommandBufferInheritanceInfo.nframebuffer(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean occlusionQueryEnable() {
        return VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address()) != 0;
    }

    @NativeType(value="VkQueryControlFlags")
    public int queryFlags() {
        return VkCommandBufferInheritanceInfo.nqueryFlags(this.address());
    }

    @NativeType(value="VkQueryPipelineStatisticFlags")
    public int pipelineStatistics() {
        return VkCommandBufferInheritanceInfo.npipelineStatistics(this.address());
    }

    public VkCommandBufferInheritanceInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandBufferInheritanceInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandBufferInheritanceInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkCommandBufferInheritanceInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo subpass(@NativeType(value="uint32_t") int value) {
        VkCommandBufferInheritanceInfo.nsubpass(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo framebuffer(@NativeType(value="VkFramebuffer") long value) {
        VkCommandBufferInheritanceInfo.nframebuffer(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo occlusionQueryEnable(@NativeType(value="VkBool32") boolean value) {
        VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkCommandBufferInheritanceInfo queryFlags(@NativeType(value="VkQueryControlFlags") int value) {
        VkCommandBufferInheritanceInfo.nqueryFlags(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
        VkCommandBufferInheritanceInfo.npipelineStatistics(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo set(int sType, long pNext, long renderPass, int subpass, long framebuffer, boolean occlusionQueryEnable, int queryFlags, int pipelineStatistics) {
        this.sType(sType);
        this.pNext(pNext);
        this.renderPass(renderPass);
        this.subpass(subpass);
        this.framebuffer(framebuffer);
        this.occlusionQueryEnable(occlusionQueryEnable);
        this.queryFlags(queryFlags);
        this.pipelineStatistics(pipelineStatistics);
        return this;
    }

    public VkCommandBufferInheritanceInfo set(VkCommandBufferInheritanceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCommandBufferInheritanceInfo malloc() {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo calloc() {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo create() {
        return new VkCommandBufferInheritanceInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo create(long address) {
        return new VkCommandBufferInheritanceInfo(address, null);
    }

    @Nullable
    public static VkCommandBufferInheritanceInfo createSafe(long address) {
        return address == 0L ? null : VkCommandBufferInheritanceInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkCommandBufferInheritanceInfo.create(VkCommandBufferInheritanceInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkCommandBufferInheritanceInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkCommandBufferInheritanceInfo.create(address, capacity);
    }

    public static VkCommandBufferInheritanceInfo mallocStack() {
        return VkCommandBufferInheritanceInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferInheritanceInfo callocStack() {
        return VkCommandBufferInheritanceInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferInheritanceInfo mallocStack(MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo callocStack(MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferInheritanceInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCommandBufferInheritanceInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RENDERPASS);
    }

    public static int nsubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASS);
    }

    public static long nframebuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FRAMEBUFFER);
    }

    public static int nocclusionQueryEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OCCLUSIONQUERYENABLE);
    }

    public static int nqueryFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUERYFLAGS);
    }

    public static int npipelineStatistics(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINESTATISTICS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RENDERPASS, value);
    }

    public static void nsubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASS, value);
    }

    public static void nframebuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FRAMEBUFFER, value);
    }

    public static void nocclusionQueryEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OCCLUSIONQUERYENABLE, value);
    }

    public static void nqueryFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUERYFLAGS, value);
    }

    public static void npipelineStatistics(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINESTATISTICS, value);
    }

    static {
        Struct.Layout layout = VkCommandBufferInheritanceInfo.__struct(VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(POINTER_SIZE), VkCommandBufferInheritanceInfo.__member(8), VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(8), VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RENDERPASS = layout.offsetof(2);
        SUBPASS = layout.offsetof(3);
        FRAMEBUFFER = layout.offsetof(4);
        OCCLUSIONQUERYENABLE = layout.offsetof(5);
        QUERYFLAGS = layout.offsetof(6);
        PIPELINESTATISTICS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferInheritanceInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCommandBufferInheritanceInfo newInstance(long address) {
            return new VkCommandBufferInheritanceInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandBufferInheritanceInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandBufferInheritanceInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkCommandBufferInheritanceInfo.nrenderPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkCommandBufferInheritanceInfo.nsubpass(this.address());
        }

        @NativeType(value="VkFramebuffer")
        public long framebuffer() {
            return VkCommandBufferInheritanceInfo.nframebuffer(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean occlusionQueryEnable() {
            return VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address()) != 0;
        }

        @NativeType(value="VkQueryControlFlags")
        public int queryFlags() {
            return VkCommandBufferInheritanceInfo.nqueryFlags(this.address());
        }

        @NativeType(value="VkQueryPipelineStatisticFlags")
        public int pipelineStatistics() {
            return VkCommandBufferInheritanceInfo.npipelineStatistics(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandBufferInheritanceInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandBufferInheritanceInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkCommandBufferInheritanceInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkCommandBufferInheritanceInfo.nsubpass(this.address(), value);
            return this;
        }

        public Buffer framebuffer(@NativeType(value="VkFramebuffer") long value) {
            VkCommandBufferInheritanceInfo.nframebuffer(this.address(), value);
            return this;
        }

        public Buffer occlusionQueryEnable(@NativeType(value="VkBool32") boolean value) {
            VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer queryFlags(@NativeType(value="VkQueryControlFlags") int value) {
            VkCommandBufferInheritanceInfo.nqueryFlags(this.address(), value);
            return this;
        }

        public Buffer pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
            VkCommandBufferInheritanceInfo.npipelineStatistics(this.address(), value);
            return this;
        }
    }
}

