/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferMemoryRequirementsInfo2;

public class VkBufferMemoryRequirementsInfo2KHR
extends VkBufferMemoryRequirementsInfo2 {
    VkBufferMemoryRequirementsInfo2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBufferMemoryRequirementsInfo2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBufferMemoryRequirementsInfo2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferMemoryRequirementsInfo2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR pNext(@NativeType(value="void const *") long value) {
        VkBufferMemoryRequirementsInfo2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferMemoryRequirementsInfo2KHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferMemoryRequirementsInfo2KHR set(VkBufferMemoryRequirementsInfo2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferMemoryRequirementsInfo2KHR malloc() {
        return VkBufferMemoryRequirementsInfo2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR calloc() {
        return VkBufferMemoryRequirementsInfo2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR create() {
        return new VkBufferMemoryRequirementsInfo2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR create(long address) {
        return new VkBufferMemoryRequirementsInfo2KHR(address, null);
    }

    @Nullable
    public static VkBufferMemoryRequirementsInfo2KHR createSafe(long address) {
        return address == 0L ? null : VkBufferMemoryRequirementsInfo2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.create(VkBufferMemoryRequirementsInfo2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBufferMemoryRequirementsInfo2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferMemoryRequirementsInfo2KHR.create(address, capacity);
    }

    public static VkBufferMemoryRequirementsInfo2KHR mallocStack() {
        return VkBufferMemoryRequirementsInfo2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferMemoryRequirementsInfo2KHR callocStack() {
        return VkBufferMemoryRequirementsInfo2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferMemoryRequirementsInfo2KHR mallocStack(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR callocStack(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferMemoryRequirementsInfo2.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBufferMemoryRequirementsInfo2KHR newInstance(long address) {
            return new VkBufferMemoryRequirementsInfo2KHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferMemoryRequirementsInfo2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferMemoryRequirementsInfo2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferMemoryRequirementsInfo2KHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

