/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindBufferMemoryInfo;

public class VkBindBufferMemoryInfoKHR
extends VkBindBufferMemoryInfo {
    VkBindBufferMemoryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindBufferMemoryInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindBufferMemoryInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkBindBufferMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBindBufferMemoryInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindBufferMemoryInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindBufferMemoryInfoKHR.nmemoryOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR set(int sType, long pNext, long buffer, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindBufferMemoryInfoKHR set(VkBindBufferMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryInfoKHR malloc() {
        return VkBindBufferMemoryInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR calloc() {
        return VkBindBufferMemoryInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR create() {
        return new VkBindBufferMemoryInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR create(long address) {
        return new VkBindBufferMemoryInfoKHR(address, null);
    }

    @Nullable
    public static VkBindBufferMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindBufferMemoryInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindBufferMemoryInfoKHR.create(VkBindBufferMemoryInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindBufferMemoryInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindBufferMemoryInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindBufferMemoryInfoKHR.create(address, capacity);
    }

    public static VkBindBufferMemoryInfoKHR mallocStack() {
        return VkBindBufferMemoryInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryInfoKHR callocStack() {
        return VkBindBufferMemoryInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindBufferMemoryInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindBufferMemoryInfoKHR newInstance(long address) {
            return new VkBindBufferMemoryInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBindBufferMemoryInfoKHR.nbuffer(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindBufferMemoryInfoKHR.nmemory(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindBufferMemoryInfoKHR.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

