/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBaseOutStructure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    VkBaseOutStructure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBaseOutStructure(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBaseOutStructure.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBaseOutStructure.nsType(this.address());
    }

    @Nullable
    @NativeType(value="VkBaseOutStructure *")
    public VkBaseOutStructure pNext() {
        return VkBaseOutStructure.npNext(this.address());
    }

    public VkBaseOutStructure sType(@NativeType(value="VkStructureType") int value) {
        VkBaseOutStructure.nsType(this.address(), value);
        return this;
    }

    public VkBaseOutStructure pNext(@Nullable @NativeType(value="VkBaseOutStructure *") VkBaseOutStructure value) {
        VkBaseOutStructure.npNext(this.address(), value);
        return this;
    }

    public VkBaseOutStructure set(int sType, @Nullable VkBaseOutStructure pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkBaseOutStructure set(VkBaseOutStructure src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBaseOutStructure malloc() {
        return VkBaseOutStructure.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBaseOutStructure calloc() {
        return VkBaseOutStructure.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBaseOutStructure create() {
        return new VkBaseOutStructure(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBaseOutStructure create(long address) {
        return new VkBaseOutStructure(address, null);
    }

    @Nullable
    public static VkBaseOutStructure createSafe(long address) {
        return address == 0L ? null : VkBaseOutStructure.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBaseOutStructure.create(VkBaseOutStructure.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBaseOutStructure.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBaseOutStructure.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBaseOutStructure.create(address, capacity);
    }

    public static VkBaseOutStructure mallocStack() {
        return VkBaseOutStructure.mallocStack(MemoryStack.stackGet());
    }

    public static VkBaseOutStructure callocStack() {
        return VkBaseOutStructure.callocStack(MemoryStack.stackGet());
    }

    public static VkBaseOutStructure mallocStack(MemoryStack stack) {
        return VkBaseOutStructure.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBaseOutStructure callocStack(MemoryStack stack) {
        return VkBaseOutStructure.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBaseOutStructure.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBaseOutStructure.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBaseOutStructure.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBaseOutStructure.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    @Nullable
    public static VkBaseOutStructure npNext(long struct) {
        return VkBaseOutStructure.createSafe(MemoryUtil.memGetAddress(struct + (long)PNEXT));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, @Nullable VkBaseOutStructure value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkBaseOutStructure.__struct(VkBaseOutStructure.__member(4), VkBaseOutStructure.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkBaseOutStructure, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBaseOutStructure newInstance(long address) {
            return new VkBaseOutStructure(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBaseOutStructure.nsType(this.address());
        }

        @Nullable
        @NativeType(value="VkBaseOutStructure *")
        public VkBaseOutStructure pNext() {
            return VkBaseOutStructure.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBaseOutStructure.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@Nullable @NativeType(value="VkBaseOutStructure *") VkBaseOutStructure value) {
            VkBaseOutStructure.npNext(this.address(), value);
            return this;
        }
    }
}

