/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FORMAT;
    public static final int SAMPLES;
    public static final int LOADOP;
    public static final int STOREOP;
    public static final int STENCILLOADOP;
    public static final int STENCILSTOREOP;
    public static final int INITIALLAYOUT;
    public static final int FINALLAYOUT;

    VkAttachmentDescription(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkAttachmentDescription(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAttachmentDescription.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkAttachmentDescriptionFlags")
    public int flags() {
        return VkAttachmentDescription.nflags(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkAttachmentDescription.nformat(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int samples() {
        return VkAttachmentDescription.nsamples(this.address());
    }

    @NativeType(value="VkAttachmentLoadOp")
    public int loadOp() {
        return VkAttachmentDescription.nloadOp(this.address());
    }

    @NativeType(value="VkAttachmentStoreOp")
    public int storeOp() {
        return VkAttachmentDescription.nstoreOp(this.address());
    }

    @NativeType(value="VkAttachmentLoadOp")
    public int stencilLoadOp() {
        return VkAttachmentDescription.nstencilLoadOp(this.address());
    }

    @NativeType(value="VkAttachmentStoreOp")
    public int stencilStoreOp() {
        return VkAttachmentDescription.nstencilStoreOp(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int initialLayout() {
        return VkAttachmentDescription.ninitialLayout(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int finalLayout() {
        return VkAttachmentDescription.nfinalLayout(this.address());
    }

    public VkAttachmentDescription flags(@NativeType(value="VkAttachmentDescriptionFlags") int value) {
        VkAttachmentDescription.nflags(this.address(), value);
        return this;
    }

    public VkAttachmentDescription format(@NativeType(value="VkFormat") int value) {
        VkAttachmentDescription.nformat(this.address(), value);
        return this;
    }

    public VkAttachmentDescription samples(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkAttachmentDescription.nsamples(this.address(), value);
        return this;
    }

    public VkAttachmentDescription loadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
        VkAttachmentDescription.nloadOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription storeOp(@NativeType(value="VkAttachmentStoreOp") int value) {
        VkAttachmentDescription.nstoreOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription stencilLoadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
        VkAttachmentDescription.nstencilLoadOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription stencilStoreOp(@NativeType(value="VkAttachmentStoreOp") int value) {
        VkAttachmentDescription.nstencilStoreOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription initialLayout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentDescription.ninitialLayout(this.address(), value);
        return this;
    }

    public VkAttachmentDescription finalLayout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentDescription.nfinalLayout(this.address(), value);
        return this;
    }

    public VkAttachmentDescription set(int flags, int format, int samples, int loadOp, int storeOp, int stencilLoadOp, int stencilStoreOp, int initialLayout, int finalLayout) {
        this.flags(flags);
        this.format(format);
        this.samples(samples);
        this.loadOp(loadOp);
        this.storeOp(storeOp);
        this.stencilLoadOp(stencilLoadOp);
        this.stencilStoreOp(stencilStoreOp);
        this.initialLayout(initialLayout);
        this.finalLayout(finalLayout);
        return this;
    }

    public VkAttachmentDescription set(VkAttachmentDescription src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAttachmentDescription malloc() {
        return VkAttachmentDescription.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAttachmentDescription calloc() {
        return VkAttachmentDescription.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAttachmentDescription create() {
        return new VkAttachmentDescription(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAttachmentDescription create(long address) {
        return new VkAttachmentDescription(address, null);
    }

    @Nullable
    public static VkAttachmentDescription createSafe(long address) {
        return address == 0L ? null : VkAttachmentDescription.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentDescription.create(VkAttachmentDescription.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentDescription.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkAttachmentDescription.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAttachmentDescription.create(address, capacity);
    }

    public static VkAttachmentDescription mallocStack() {
        return VkAttachmentDescription.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentDescription callocStack() {
        return VkAttachmentDescription.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentDescription mallocStack(MemoryStack stack) {
        return VkAttachmentDescription.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentDescription callocStack(MemoryStack stack) {
        return VkAttachmentDescription.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentDescription.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentDescription.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentDescription.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentDescription.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nsamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLES);
    }

    public static int nloadOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOADOP);
    }

    public static int nstoreOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STOREOP);
    }

    public static int nstencilLoadOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCILLOADOP);
    }

    public static int nstencilStoreOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCILSTOREOP);
    }

    public static int ninitialLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INITIALLAYOUT);
    }

    public static int nfinalLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FINALLAYOUT);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nsamples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLES, value);
    }

    public static void nloadOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOADOP, value);
    }

    public static void nstoreOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STOREOP, value);
    }

    public static void nstencilLoadOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCILLOADOP, value);
    }

    public static void nstencilStoreOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCILSTOREOP, value);
    }

    public static void ninitialLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INITIALLAYOUT, value);
    }

    public static void nfinalLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FINALLAYOUT, value);
    }

    static {
        Struct.Layout layout = VkAttachmentDescription.__struct(VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        SAMPLES = layout.offsetof(2);
        LOADOP = layout.offsetof(3);
        STOREOP = layout.offsetof(4);
        STENCILLOADOP = layout.offsetof(5);
        STENCILSTOREOP = layout.offsetof(6);
        INITIALLAYOUT = layout.offsetof(7);
        FINALLAYOUT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentDescription, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAttachmentDescription newInstance(long address) {
            return new VkAttachmentDescription(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkAttachmentDescriptionFlags")
        public int flags() {
            return VkAttachmentDescription.nflags(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkAttachmentDescription.nformat(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int samples() {
            return VkAttachmentDescription.nsamples(this.address());
        }

        @NativeType(value="VkAttachmentLoadOp")
        public int loadOp() {
            return VkAttachmentDescription.nloadOp(this.address());
        }

        @NativeType(value="VkAttachmentStoreOp")
        public int storeOp() {
            return VkAttachmentDescription.nstoreOp(this.address());
        }

        @NativeType(value="VkAttachmentLoadOp")
        public int stencilLoadOp() {
            return VkAttachmentDescription.nstencilLoadOp(this.address());
        }

        @NativeType(value="VkAttachmentStoreOp")
        public int stencilStoreOp() {
            return VkAttachmentDescription.nstencilStoreOp(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int initialLayout() {
            return VkAttachmentDescription.ninitialLayout(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int finalLayout() {
            return VkAttachmentDescription.nfinalLayout(this.address());
        }

        public Buffer flags(@NativeType(value="VkAttachmentDescriptionFlags") int value) {
            VkAttachmentDescription.nflags(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkAttachmentDescription.nformat(this.address(), value);
            return this;
        }

        public Buffer samples(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkAttachmentDescription.nsamples(this.address(), value);
            return this;
        }

        public Buffer loadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
            VkAttachmentDescription.nloadOp(this.address(), value);
            return this;
        }

        public Buffer storeOp(@NativeType(value="VkAttachmentStoreOp") int value) {
            VkAttachmentDescription.nstoreOp(this.address(), value);
            return this;
        }

        public Buffer stencilLoadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
            VkAttachmentDescription.nstencilLoadOp(this.address(), value);
            return this;
        }

        public Buffer stencilStoreOp(@NativeType(value="VkAttachmentStoreOp") int value) {
            VkAttachmentDescription.nstencilStoreOp(this.address(), value);
            return this;
        }

        public Buffer initialLayout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentDescription.ninitialLayout(this.address(), value);
            return this;
        }

        public Buffer finalLayout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentDescription.nfinalLayout(this.address(), value);
            return this;
        }
    }
}

