/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkApplicationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PAPPLICATIONNAME;
    public static final int APPLICATIONVERSION;
    public static final int PENGINENAME;
    public static final int ENGINEVERSION;
    public static final int APIVERSION;

    VkApplicationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkApplicationInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkApplicationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkApplicationInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkApplicationInfo.npNext(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pApplicationName() {
        return VkApplicationInfo.npApplicationName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pApplicationNameString() {
        return VkApplicationInfo.npApplicationNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int applicationVersion() {
        return VkApplicationInfo.napplicationVersion(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pEngineName() {
        return VkApplicationInfo.npEngineName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pEngineNameString() {
        return VkApplicationInfo.npEngineNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int engineVersion() {
        return VkApplicationInfo.nengineVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int apiVersion() {
        return VkApplicationInfo.napiVersion(this.address());
    }

    public VkApplicationInfo sType(@NativeType(value="VkStructureType") int value) {
        VkApplicationInfo.nsType(this.address(), value);
        return this;
    }

    public VkApplicationInfo pNext(@NativeType(value="void const *") long value) {
        VkApplicationInfo.npNext(this.address(), value);
        return this;
    }

    public VkApplicationInfo pApplicationName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkApplicationInfo.npApplicationName(this.address(), value);
        return this;
    }

    public VkApplicationInfo applicationVersion(@NativeType(value="uint32_t") int value) {
        VkApplicationInfo.napplicationVersion(this.address(), value);
        return this;
    }

    public VkApplicationInfo pEngineName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkApplicationInfo.npEngineName(this.address(), value);
        return this;
    }

    public VkApplicationInfo engineVersion(@NativeType(value="uint32_t") int value) {
        VkApplicationInfo.nengineVersion(this.address(), value);
        return this;
    }

    public VkApplicationInfo apiVersion(@NativeType(value="uint32_t") int value) {
        VkApplicationInfo.napiVersion(this.address(), value);
        return this;
    }

    public VkApplicationInfo set(int sType, long pNext, @Nullable ByteBuffer pApplicationName, int applicationVersion, @Nullable ByteBuffer pEngineName, int engineVersion, int apiVersion) {
        this.sType(sType);
        this.pNext(pNext);
        this.pApplicationName(pApplicationName);
        this.applicationVersion(applicationVersion);
        this.pEngineName(pEngineName);
        this.engineVersion(engineVersion);
        this.apiVersion(apiVersion);
        return this;
    }

    public VkApplicationInfo set(VkApplicationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkApplicationInfo malloc() {
        return VkApplicationInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkApplicationInfo calloc() {
        return VkApplicationInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkApplicationInfo create() {
        return new VkApplicationInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkApplicationInfo create(long address) {
        return new VkApplicationInfo(address, null);
    }

    @Nullable
    public static VkApplicationInfo createSafe(long address) {
        return address == 0L ? null : VkApplicationInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkApplicationInfo.create(VkApplicationInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkApplicationInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkApplicationInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkApplicationInfo.create(address, capacity);
    }

    public static VkApplicationInfo mallocStack() {
        return VkApplicationInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkApplicationInfo callocStack() {
        return VkApplicationInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkApplicationInfo mallocStack(MemoryStack stack) {
        return VkApplicationInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkApplicationInfo callocStack(MemoryStack stack) {
        return VkApplicationInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkApplicationInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkApplicationInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkApplicationInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkApplicationInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    @Nullable
    public static ByteBuffer npApplicationName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)PAPPLICATIONNAME));
    }

    @Nullable
    public static String npApplicationNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)PAPPLICATIONNAME));
    }

    public static int napplicationVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)APPLICATIONVERSION);
    }

    @Nullable
    public static ByteBuffer npEngineName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)PENGINENAME));
    }

    @Nullable
    public static String npEngineNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)PENGINENAME));
    }

    public static int nengineVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENGINEVERSION);
    }

    public static int napiVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)APIVERSION);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npApplicationName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PAPPLICATIONNAME, MemoryUtil.memAddressSafe(value));
    }

    public static void napplicationVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)APPLICATIONVERSION, value);
    }

    public static void npEngineName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PENGINENAME, MemoryUtil.memAddressSafe(value));
    }

    public static void nengineVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENGINEVERSION, value);
    }

    public static void napiVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)APIVERSION, value);
    }

    static {
        Struct.Layout layout = VkApplicationInfo.__struct(VkApplicationInfo.__member(4), VkApplicationInfo.__member(POINTER_SIZE), VkApplicationInfo.__member(POINTER_SIZE), VkApplicationInfo.__member(4), VkApplicationInfo.__member(POINTER_SIZE), VkApplicationInfo.__member(4), VkApplicationInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PAPPLICATIONNAME = layout.offsetof(2);
        APPLICATIONVERSION = layout.offsetof(3);
        PENGINENAME = layout.offsetof(4);
        ENGINEVERSION = layout.offsetof(5);
        APIVERSION = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkApplicationInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkApplicationInfo newInstance(long address) {
            return new VkApplicationInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkApplicationInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkApplicationInfo.npNext(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pApplicationName() {
            return VkApplicationInfo.npApplicationName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pApplicationNameString() {
            return VkApplicationInfo.npApplicationNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int applicationVersion() {
            return VkApplicationInfo.napplicationVersion(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pEngineName() {
            return VkApplicationInfo.npEngineName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pEngineNameString() {
            return VkApplicationInfo.npEngineNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int engineVersion() {
            return VkApplicationInfo.nengineVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int apiVersion() {
            return VkApplicationInfo.napiVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkApplicationInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkApplicationInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pApplicationName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkApplicationInfo.npApplicationName(this.address(), value);
            return this;
        }

        public Buffer applicationVersion(@NativeType(value="uint32_t") int value) {
            VkApplicationInfo.napplicationVersion(this.address(), value);
            return this;
        }

        public Buffer pEngineName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkApplicationInfo.npEngineName(this.address(), value);
            return this;
        }

        public Buffer engineVersion(@NativeType(value="uint32_t") int value) {
            VkApplicationInfo.nengineVersion(this.address(), value);
            return this;
        }

        public Buffer apiVersion(@NativeType(value="uint32_t") int value) {
            VkApplicationInfo.napiVersion(this.address(), value);
            return this;
        }
    }
}

