/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;

public class NVExternalMemoryWin32 {
    public static final int VK_NV_EXTERNAL_MEMORY_WIN32_SPEC_VERSION = 1;
    public static final String VK_NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME = "VK_NV_external_memory_win32";
    public static final int VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV = 1000057000;
    public static final int VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV = 1000057001;

    protected NVExternalMemoryWin32() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME) && VK.checkExtension(VK_NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME, VK.isSupported(provider, "vkGetMemoryWin32HandleNV", caps));
    }

    public static int nvkGetMemoryWin32HandleNV(VkDevice device, long memory, int handleType, long pHandle) {
        long __functionAddress = device.getCapabilities().vkGetMemoryWin32HandleNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), memory, handleType, pHandle);
    }

    @NativeType(value="VkResult")
    public static int vkGetMemoryWin32HandleNV(VkDevice device, @NativeType(value="VkDeviceMemory") long memory, @NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int handleType, @NativeType(value="HANDLE *") PointerBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check(pHandle, 1);
        }
        return NVExternalMemoryWin32.nvkGetMemoryWin32HandleNV(device, memory, handleType, MemoryUtil.memAddress(pHandle));
    }
}

