/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkMemoryGetWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkMemoryWin32HandlePropertiesKHR;

public class KHRExternalMemoryWin32 {
    public static final int VK_KHR_EXTERNAL_MEMORY_WIN32_SPEC_VERSION = 1;
    public static final String VK_KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME = "VK_KHR_external_memory_win32";
    public static final int VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR = 1000073000;
    public static final int VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR = 1000073001;
    public static final int VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR = 1000073002;
    public static final int VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR = 1000073003;

    protected KHRExternalMemoryWin32() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME) && VK.checkExtension(VK_KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME, VK.isSupported(provider, "vkGetMemoryWin32HandleKHR", caps) && VK.isSupported(provider, "vkGetMemoryWin32HandlePropertiesKHR", caps));
    }

    public static int nvkGetMemoryWin32HandleKHR(VkDevice device, long pGetWin32HandleInfo, long pHandle) {
        long __functionAddress = device.getCapabilities().vkGetMemoryWin32HandleKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pGetWin32HandleInfo, pHandle);
    }

    @NativeType(value="VkResult")
    public static int vkGetMemoryWin32HandleKHR(VkDevice device, @NativeType(value="VkMemoryGetWin32HandleInfoKHR const *") VkMemoryGetWin32HandleInfoKHR pGetWin32HandleInfo, @NativeType(value="HANDLE *") PointerBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check(pHandle, 1);
        }
        return KHRExternalMemoryWin32.nvkGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo.address(), MemoryUtil.memAddress(pHandle));
    }

    public static int nvkGetMemoryWin32HandlePropertiesKHR(VkDevice device, int handleType, long handle, long pMemoryWin32HandleProperties) {
        long __functionAddress = device.getCapabilities().vkGetMemoryWin32HandlePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(handle);
        }
        return JNI.callPPPI(__functionAddress, device.address(), handleType, handle, pMemoryWin32HandleProperties);
    }

    @NativeType(value="VkResult")
    public static int vkGetMemoryWin32HandlePropertiesKHR(VkDevice device, @NativeType(value="VkExternalMemoryHandleTypeFlagBits") int handleType, @NativeType(value="HANDLE") long handle, @NativeType(value="VkMemoryWin32HandlePropertiesKHR *") VkMemoryWin32HandlePropertiesKHR pMemoryWin32HandleProperties) {
        return KHRExternalMemoryWin32.nvkGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties.address());
    }
}

