/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAcquireNextImageInfoKHR;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceGroupPresentCapabilitiesKHR;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkRect2D;

public class KHRDeviceGroup {
    public static final int VK_KHR_DEVICE_GROUP_SPEC_VERSION = 3;
    public static final String VK_KHR_DEVICE_GROUP_EXTENSION_NAME = "VK_KHR_device_group";
    public static final int VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR = 1000060000;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR = 1000060003;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR = 1000060004;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR = 1000060005;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR = 1000060006;
    public static final int VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR = 1;
    public static final int VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR = 2;
    public static final int VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR = 4;
    public static final int VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR = 8;
    public static final int VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR = 1;
    public static final int VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR = 8;
    public static final int VK_PIPELINE_CREATE_DISPATCH_BASE_KHR = 16;
    public static final int VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR = 4;
    public static final int VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR = 1000060013;
    public static final int VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR = 1000060014;
    public static final int VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR = 64;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR = 1000060007;
    public static final int VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR = 1000060008;
    public static final int VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR = 1000060009;
    public static final int VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR = 1000060010;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR = 1000060011;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR = 1000060012;
    public static final int VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR = 1;

    protected KHRDeviceGroup() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_DEVICE_GROUP_EXTENSION_NAME) && VK.checkExtension(VK_KHR_DEVICE_GROUP_EXTENSION_NAME, VK.isSupported(provider, "vkGetPhysicalDevicePresentRectanglesKHR", caps, ext.contains("VK_KHR_surface")));
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_DEVICE_GROUP_EXTENSION_NAME) && VK.checkExtension(VK_KHR_DEVICE_GROUP_EXTENSION_NAME, VK.isSupported(provider, "vkGetDeviceGroupPeerMemoryFeaturesKHR", caps) && VK.isSupported(provider, "vkCmdSetDeviceMaskKHR", caps) && VK.isSupported(provider, "vkCmdDispatchBaseKHR", caps) && VK.isSupported(provider, "vkGetDeviceGroupPresentCapabilitiesKHR", caps, ext.contains("VK_KHR_surface")) && VK.isSupported(provider, "vkGetDeviceGroupSurfacePresentModesKHR", caps, ext.contains("VK_KHR_surface")) && VK.isSupported(provider, "vkAcquireNextImage2KHR", caps, ext.contains("VK_KHR_swapchain")));
    }

    public static void nvkGetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, int heapIndex, int localDeviceIndex, int remoteDeviceIndex, long pPeerMemoryFeatures) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupPeerMemoryFeaturesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, device.address(), heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    }

    public static void vkGetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, @NativeType(value="uint32_t") int heapIndex, @NativeType(value="uint32_t") int localDeviceIndex, @NativeType(value="uint32_t") int remoteDeviceIndex, @NativeType(value="VkPeerMemoryFeatureFlags *") IntBuffer pPeerMemoryFeatures) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPeerMemoryFeatures, 1);
        }
        KHRDeviceGroup.nvkGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex, MemoryUtil.memAddress(pPeerMemoryFeatures));
    }

    public static void vkCmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int deviceMask) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDeviceMaskKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, commandBuffer.address(), deviceMask);
    }

    public static void vkCmdDispatchBaseKHR(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int baseGroupX, @NativeType(value="uint32_t") int baseGroupY, @NativeType(value="uint32_t") int baseGroupZ, @NativeType(value="uint32_t") int groupCountX, @NativeType(value="uint32_t") int groupCountY, @NativeType(value="uint32_t") int groupCountZ) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchBaseKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, commandBuffer.address(), baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    }

    public static int nvkGetDeviceGroupPresentCapabilitiesKHR(VkDevice device, long pDeviceGroupPresentCapabilities) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupPresentCapabilitiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, device.address(), pDeviceGroupPresentCapabilities);
    }

    @NativeType(value="VkResult")
    public static int vkGetDeviceGroupPresentCapabilitiesKHR(VkDevice device, @NativeType(value="VkDeviceGroupPresentCapabilitiesKHR *") VkDeviceGroupPresentCapabilitiesKHR pDeviceGroupPresentCapabilities) {
        return KHRDeviceGroup.nvkGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities.address());
    }

    public static int nvkGetDeviceGroupSurfacePresentModesKHR(VkDevice device, long surface, long pModes) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupSurfacePresentModesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), surface, pModes);
    }

    @NativeType(value="VkResult")
    public static int vkGetDeviceGroupSurfacePresentModesKHR(VkDevice device, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkDeviceGroupPresentModeFlagsKHR *") IntBuffer pModes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pModes, 1);
        }
        return KHRDeviceGroup.nvkGetDeviceGroupSurfacePresentModesKHR(device, surface, MemoryUtil.memAddress(pModes));
    }

    public static int nvkGetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, long surface, long pRectCount, long pRects) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDevicePresentRectanglesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pRectCount, pRects);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") IntBuffer pRectCount, @Nullable @NativeType(value="VkRect2D *") VkRect2D.Buffer pRects) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pRectCount, 1);
            Checks.checkSafe(pRects, pRectCount.get(pRectCount.position()));
        }
        return KHRDeviceGroup.nvkGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, MemoryUtil.memAddress(pRectCount), MemoryUtil.memAddressSafe(pRects));
    }

    public static int nvkAcquireNextImage2KHR(VkDevice device, long pAcquireInfo, long pImageIndex) {
        long __functionAddress = device.getCapabilities().vkAcquireNextImage2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pAcquireInfo, pImageIndex);
    }

    @NativeType(value="VkResult")
    public static int vkAcquireNextImage2KHR(VkDevice device, @NativeType(value="VkAcquireNextImageInfoKHR const *") VkAcquireNextImageInfoKHR pAcquireInfo, @NativeType(value="uint32_t *") IntBuffer pImageIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pImageIndex, 1);
        }
        return KHRDeviceGroup.nvkAcquireNextImage2KHR(device, pAcquireInfo.address(), MemoryUtil.memAddress(pImageIndex));
    }

    public static void vkGetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, @NativeType(value="uint32_t") int heapIndex, @NativeType(value="uint32_t") int localDeviceIndex, @NativeType(value="uint32_t") int remoteDeviceIndex, @NativeType(value="VkPeerMemoryFeatureFlags *") int[] pPeerMemoryFeatures) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupPeerMemoryFeaturesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPeerMemoryFeatures, 1);
        }
        JNI.callPPV(__functionAddress, device.address(), heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    }

    @NativeType(value="VkResult")
    public static int vkGetDeviceGroupSurfacePresentModesKHR(VkDevice device, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkDeviceGroupPresentModeFlagsKHR *") int[] pModes) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupSurfacePresentModesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pModes, 1);
        }
        return JNI.callPJPI(__functionAddress, device.address(), surface, pModes);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") int[] pRectCount, @Nullable @NativeType(value="VkRect2D *") VkRect2D.Buffer pRects) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDevicePresentRectanglesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pRectCount, 1);
            Checks.checkSafe(pRects, pRectCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pRectCount, MemoryUtil.memAddressSafe(pRects));
    }

    @NativeType(value="VkResult")
    public static int vkAcquireNextImage2KHR(VkDevice device, @NativeType(value="VkAcquireNextImageInfoKHR const *") VkAcquireNextImageInfoKHR pAcquireInfo, @NativeType(value="uint32_t *") int[] pImageIndex) {
        long __functionAddress = device.getCapabilities().vkAcquireNextImage2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pImageIndex, 1);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pAcquireInfo.address(), pImageIndex);
    }
}

