/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDescriptorUpdateTemplateCreateInfo;
import org.lwjgl.vulkan.VkDevice;

public class KHRDescriptorUpdateTemplate {
    public static final int VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION = 1;
    public static final String VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME = "VK_KHR_descriptor_update_template";
    public static final int VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR = 1000085000;
    public static final int VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR = 1000085000;
    public static final int VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR = 0;
    public static final int VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR = 1;
    public static final int VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT = 1000085000;

    protected KHRDescriptorUpdateTemplate() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME) && VK.checkExtension(VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME, VK.isSupported(provider, "vkCreateDescriptorUpdateTemplateKHR", caps) && VK.isSupported(provider, "vkDestroyDescriptorUpdateTemplateKHR", caps) && VK.isSupported(provider, "vkUpdateDescriptorSetWithTemplateKHR", caps) && VK.isSupported(provider, "vkCmdPushDescriptorSetWithTemplateKHR", caps, ext.contains("VK_KHR_push_descriptor")));
    }

    public static int nvkCreateDescriptorUpdateTemplateKHR(VkDevice device, long pCreateInfo, long pAllocator, long pDescriptorUpdateTemplate) {
        long __functionAddress = device.getCapabilities().vkCreateDescriptorUpdateTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDescriptorUpdateTemplateCreateInfo.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDescriptorUpdateTemplateKHR(VkDevice device, @NativeType(value="VkDescriptorUpdateTemplateCreateInfo const *") VkDescriptorUpdateTemplateCreateInfo pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkDescriptorUpdateTemplate *") LongBuffer pDescriptorUpdateTemplate) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDescriptorUpdateTemplate, 1);
        }
        return KHRDescriptorUpdateTemplate.nvkCreateDescriptorUpdateTemplateKHR(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pDescriptorUpdateTemplate));
    }

    public static void nvkDestroyDescriptorUpdateTemplateKHR(VkDevice device, long descriptorUpdateTemplate, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDescriptorUpdateTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, device.address(), descriptorUpdateTemplate, pAllocator);
    }

    public static void vkDestroyDescriptorUpdateTemplateKHR(VkDevice device, @NativeType(value="VkDescriptorUpdateTemplate") long descriptorUpdateTemplate, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        KHRDescriptorUpdateTemplate.nvkDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static void vkUpdateDescriptorSetWithTemplateKHR(VkDevice device, @NativeType(value="VkDescriptorSet") long descriptorSet, @NativeType(value="VkDescriptorUpdateTemplate") long descriptorUpdateTemplate, @NativeType(value="void const *") long pData) {
        long __functionAddress = device.getCapabilities().vkUpdateDescriptorSetWithTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pData);
        }
        JNI.callPJJPV(__functionAddress, device.address(), descriptorSet, descriptorUpdateTemplate, pData);
    }

    public static void vkCmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkDescriptorUpdateTemplate") long descriptorUpdateTemplate, @NativeType(value="VkPipelineLayout") long layout, @NativeType(value="uint32_t") int set, @NativeType(value="void const *") long pData) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdPushDescriptorSetWithTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pData);
        }
        JNI.callPJJPV(__functionAddress, commandBuffer.address(), descriptorUpdateTemplate, layout, set, pData);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDescriptorUpdateTemplateKHR(VkDevice device, @NativeType(value="VkDescriptorUpdateTemplateCreateInfo const *") VkDescriptorUpdateTemplateCreateInfo pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkDescriptorUpdateTemplate *") long[] pDescriptorUpdateTemplate) {
        long __functionAddress = device.getCapabilities().vkCreateDescriptorUpdateTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pDescriptorUpdateTemplate, 1);
            VkDescriptorUpdateTemplateCreateInfo.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pDescriptorUpdateTemplate);
    }
}

