/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.zstd.LibZstd;
import org.lwjgl.util.zstd.ZSTDCustomMem;
import org.lwjgl.util.zstd.ZSTDFrameHeader;
import org.lwjgl.util.zstd.ZSTDFrameProgression;
import org.lwjgl.util.zstd.ZSTDInBuffer;
import org.lwjgl.util.zstd.ZSTDOutBuffer;

public class ZstdX {
    public static final int ZSTD_MAGICNUMBER = -47205080;
    public static final int ZSTD_MAGIC_SKIPPABLE_START = 407710288;
    public static final int ZSTD_MAGIC_DICTIONARY = -332356553;
    public static final int ZSTD_WINDOWLOG_MAX_32 = 30;
    public static final int ZSTD_WINDOWLOG_MAX_64 = 31;
    public static final int ZSTD_WINDOWLOG_MAX = Pointer.BITS32 ? 30 : 31;
    public static final int ZSTD_WINDOWLOG_MIN = 10;
    public static final int ZSTD_HASHLOG_MAX = ZSTD_WINDOWLOG_MAX < 30 ? ZSTD_WINDOWLOG_MAX : 30;
    public static final int ZSTD_HASHLOG_MIN = 6;
    public static final int ZSTD_CHAINLOG_MAX_32 = 29;
    public static final int ZSTD_CHAINLOG_MAX_64 = 30;
    public static final int ZSTD_CHAINLOG_MAX = Pointer.BITS32 ? 29 : 30;
    public static final int ZSTD_CHAINLOG_MIN = 6;
    public static final int ZSTD_HASHLOG3_MAX = 17;
    public static final int ZSTD_SEARCHLOG_MAX = ZSTD_WINDOWLOG_MAX - 1;
    public static final int ZSTD_SEARCHLOG_MIN = 1;
    public static final int ZSTD_SEARCHLENGTH_MAX = 7;
    public static final int ZSTD_SEARCHLENGTH_MIN = 3;
    public static final int ZSTD_LDM_MINMATCH_MIN = 4;
    public static final int ZSTD_LDM_MINMATCH_MAX = 4096;
    public static final int ZSTD_LDM_BUCKETSIZELOG_MAX = 8;
    public static final int ZSTD_FRAMEHEADERSIZE_PREFIX = 5;
    public static final int ZSTD_FRAMEHEADERSIZE_MIN = 6;
    public static final int ZSTD_FRAMEHEADERSIZE_MAX = 18;
    public static final int ZSTD_fast = 1;
    public static final int ZSTD_dfast = 2;
    public static final int ZSTD_greedy = 3;
    public static final int ZSTD_lazy = 4;
    public static final int ZSTD_lazy2 = 5;
    public static final int ZSTD_btlazy2 = 6;
    public static final int ZSTD_btopt = 7;
    public static final int ZSTD_btultra = 8;
    public static final int ZSTD_dlm_byCopy = 0;
    public static final int ZSTD_dlm_byRef = 1;
    public static final int ZSTD_dct_auto = 0;
    public static final int ZSTD_dct_rawContent = 1;
    public static final int ZSTD_dct_fullDict = 2;
    public static final int ZSTD_frame = 0;
    public static final int ZSTD_skippableFrame = 1;
    public static final int ZSTD_f_zstd1 = 0;
    public static final int ZSTD_f_zstd1_magicless = 1;
    public static final int ZSTD_p_format = 10;
    public static final int ZSTD_p_compressionLevel = 100;
    public static final int ZSTD_p_windowLog = 101;
    public static final int ZSTD_p_hashLog = 102;
    public static final int ZSTD_p_chainLog = 103;
    public static final int ZSTD_p_searchLog = 104;
    public static final int ZSTD_p_minMatch = 105;
    public static final int ZSTD_p_targetLength = 106;
    public static final int ZSTD_p_compressionStrategy = 107;
    public static final int ZSTD_p_enableLongDistanceMatching = 160;
    public static final int ZSTD_p_ldmHashLog = 161;
    public static final int ZSTD_p_ldmMinMatch = 162;
    public static final int ZSTD_p_ldmBucketSizeLog = 163;
    public static final int ZSTD_p_ldmHashEveryLog = 164;
    public static final int ZSTD_p_contentSizeFlag = 200;
    public static final int ZSTD_p_checksumFlag = 201;
    public static final int ZSTD_p_dictIDFlag = 202;
    public static final int ZSTD_p_nbWorkers = 400;
    public static final int ZSTD_p_nonBlockingMode = 401;
    public static final int ZSTD_p_jobSize = 402;
    public static final int ZSTD_p_overlapSizeLog = 403;
    public static final int ZSTD_p_forceMaxWindow = 1100;
    public static final int ZSTD_p_forceAttachDict = 1101;
    public static final int ZSTD_e_continue = 0;
    public static final int ZSTD_e_flush = 1;
    public static final int ZSTD_e_end = 2;
    public static final int ZSTD_BLOCKSIZELOG_MAX = 17;
    public static final int ZSTD_BLOCKSIZE_MAX = 131072;
    public static final ZSTDCustomMem ZSTD_defaultCMem;

    protected ZstdX() {
        throw new UnsupportedOperationException();
    }

    public static native long nZSTD_findFrameCompressedSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_findFrameCompressedSize(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_findFrameCompressedSize(MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_findDecompressedSize(long var0, long var2);

    @NativeType(value="unsigned long long")
    public static long ZSTD_findDecompressedSize(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_findDecompressedSize(MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_frameHeaderSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_frameHeaderSize(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_frameHeaderSize(MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_sizeof_CCtx(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_CCtx(@NativeType(value="ZSTD_CCtx const *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_sizeof_CCtx(cctx);
    }

    public static native long nZSTD_sizeof_DCtx(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_DCtx(@NativeType(value="ZSTD_DCtx const *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_sizeof_DCtx(dctx);
    }

    public static native long nZSTD_sizeof_CStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_CStream(@NativeType(value="ZSTD_CStream const *") long zcs) {
        if (Checks.CHECKS) {
            Checks.check(zcs);
        }
        return ZstdX.nZSTD_sizeof_CStream(zcs);
    }

    public static native long nZSTD_sizeof_DStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_DStream(@NativeType(value="ZSTD_DStream const *") long zds) {
        if (Checks.CHECKS) {
            Checks.check(zds);
        }
        return ZstdX.nZSTD_sizeof_DStream(zds);
    }

    public static native long nZSTD_sizeof_CDict(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_CDict(@NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check(cdict);
        }
        return ZstdX.nZSTD_sizeof_CDict(cdict);
    }

    public static native long nZSTD_sizeof_DDict(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_sizeof_DDict(@NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check(ddict);
        }
        return ZstdX.nZSTD_sizeof_DDict(ddict);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateCCtxSize(int var0);

    public static native long nZSTD_estimateCCtxSize_usingCCtxParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCCtxSize_usingCCtxParams(@NativeType(value="ZSTD_CCtx_params const *") long params) {
        if (Checks.CHECKS) {
            Checks.check(params);
        }
        return ZstdX.nZSTD_estimateCCtxSize_usingCCtxParams(params);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateDCtxSize();

    @NativeType(value="size_t")
    public static native long ZSTD_estimateCStreamSize(int var0);

    public static native long nZSTD_estimateCStreamSize_usingCCtxParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCStreamSize_usingCCtxParams(@NativeType(value="ZSTD_CCtx_params const *") long params) {
        if (Checks.CHECKS) {
            Checks.check(params);
        }
        return ZstdX.nZSTD_estimateCStreamSize_usingCCtxParams(params);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateDStreamSize(@NativeType(value="size_t") long var0);

    public static native long nZSTD_estimateDStreamSize_fromFrame(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_estimateDStreamSize_fromFrame(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_estimateDStreamSize_fromFrame(MemoryUtil.memAddress(src), src.remaining());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateCDictSize(@NativeType(value="size_t") long var0, int var2);

    @NativeType(value="size_t")
    public static native long ZSTD_estimateDDictSize(@NativeType(value="size_t") long var0, @NativeType(value="ZSTD_dictLoadMethod_e") int var2);

    private static native long nZSTD_defaultCMem();

    @NativeType(value="ZSTD_customMem *")
    private static ZSTDCustomMem ZSTD_defaultCMem() {
        long __result = ZstdX.nZSTD_defaultCMem();
        return ZSTDCustomMem.create(__result);
    }

    public static native long nZSTD_createCCtx_advanced(long var0);

    @NativeType(value="ZSTD_CCtx *")
    public static long ZSTD_createCCtx_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createCCtx_advanced(customMem.address());
    }

    public static native long nZSTD_initStaticCCtx(long var0, long var2);

    @NativeType(value="ZSTD_CCtx *")
    public static long ZSTD_initStaticCCtx(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticCCtx(MemoryUtil.memAddress(workspace), workspace.remaining());
    }

    public static native int nZSTD_isFrame(long var0, long var2);

    @NativeType(value="unsigned")
    public static boolean ZSTD_isFrame(@NativeType(value="void const *") ByteBuffer buffer) {
        return ZstdX.nZSTD_isFrame(MemoryUtil.memAddress(buffer), buffer.remaining()) != 0;
    }

    public static native long nZSTD_createDCtx_advanced(long var0);

    @NativeType(value="ZSTD_DCtx *")
    public static long ZSTD_createDCtx_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createDCtx_advanced(customMem.address());
    }

    public static native long nZSTD_initStaticDCtx(long var0, long var2);

    @NativeType(value="ZSTD_DCtx *")
    public static long ZSTD_initStaticDCtx(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticDCtx(MemoryUtil.memAddress(workspace), workspace.remaining());
    }

    public static native long nZSTD_createDDict_advanced(long var0, long var2, int var4, int var5, long var6);

    @NativeType(value="ZSTD_DDict *")
    public static long ZSTD_createDDict_advanced(@NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType, @NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createDDict_advanced(MemoryUtil.memAddress(dict), dict.remaining(), dictLoadMethod, dictContentType, customMem.address());
    }

    public static native long nZSTD_initStaticDDict(long var0, long var2, long var4, long var6, int var8, int var9);

    @NativeType(value="ZSTD_DDict const *")
    public static long ZSTD_initStaticDDict(@NativeType(value="void *") ByteBuffer workspace, @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        return ZstdX.nZSTD_initStaticDDict(MemoryUtil.memAddress(workspace), workspace.remaining(), MemoryUtil.memAddress(dict), dict.remaining(), dictLoadMethod, dictContentType);
    }

    public static native int nZSTD_getDictID_fromDict(long var0, long var2);

    @NativeType(value="unsigned int")
    public static int ZSTD_getDictID_fromDict(@NativeType(value="void const *") ByteBuffer dict) {
        return ZstdX.nZSTD_getDictID_fromDict(MemoryUtil.memAddress(dict), dict.remaining());
    }

    public static native int nZSTD_getDictID_fromDDict(long var0);

    @NativeType(value="unsigned int")
    public static int ZSTD_getDictID_fromDDict(@NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check(ddict);
        }
        return ZstdX.nZSTD_getDictID_fromDDict(ddict);
    }

    public static native int nZSTD_getDictID_fromFrame(long var0, long var2);

    @NativeType(value="unsigned int")
    public static int ZSTD_getDictID_fromFrame(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_getDictID_fromFrame(MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_createCStream_advanced(long var0);

    @NativeType(value="ZSTD_CStream *")
    public static long ZSTD_createCStream_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createCStream_advanced(customMem.address());
    }

    public static native long nZSTD_initStaticCStream(long var0, long var2);

    @NativeType(value="ZSTD_CStream *")
    public static long ZSTD_initStaticCStream(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticCStream(MemoryUtil.memAddress(workspace), workspace.remaining());
    }

    public static native long nZSTD_createDStream_advanced(long var0);

    @NativeType(value="ZSTD_DStream *")
    public static long ZSTD_createDStream_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createDStream_advanced(customMem.address());
    }

    public static native long nZSTD_initStaticDStream(long var0, long var2);

    @NativeType(value="ZSTD_DStream *")
    public static long ZSTD_initStaticDStream(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticDStream(MemoryUtil.memAddress(workspace), workspace.remaining());
    }

    public static native long nZSTD_copyCCtx(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_copyCCtx(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_CCtx const *") long preparedCCtx, @NativeType(value="unsigned long long") long pledgedSrcSize) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            Checks.check(preparedCCtx);
        }
        return ZstdX.nZSTD_copyCCtx(cctx, preparedCCtx, pledgedSrcSize);
    }

    public static native void nZSTD_getFrameProgression(long var0, long var2);

    @NativeType(value="ZSTD_frameProgression")
    public static ZSTDFrameProgression ZSTD_getFrameProgression(@NativeType(value="ZSTD_CCtx const *") long cctx, ZSTDFrameProgression __result) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        ZstdX.nZSTD_getFrameProgression(cctx, __result.address());
        return __result;
    }

    public static native long nZSTD_getFrameHeader(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_getFrameHeader(@NativeType(value="ZSTD_frameHeader *") ZSTDFrameHeader zfhPtr, @NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_getFrameHeader(zfhPtr.address(), MemoryUtil.memAddress(src), src.remaining());
    }

    public static native void nZSTD_copyDCtx(long var0, long var2);

    public static void ZSTD_copyDCtx(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_DCtx const *") long preparedDCtx) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            Checks.check(preparedDCtx);
        }
        ZstdX.nZSTD_copyDCtx(dctx, preparedDCtx);
    }

    public static native long nZSTD_CCtx_setParameter(long var0, int var2, int var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setParameter(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_cParameter") int param, @NativeType(value="unsigned int") int value) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_setParameter(cctx, param, value);
    }

    public static native long nZSTD_CCtx_getParameter(long var0, int var2, long var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_getParameter(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_cParameter") int param, @NativeType(value="unsigned *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            Checks.check((Buffer)value, 1);
        }
        return ZstdX.nZSTD_CCtx_getParameter(cctx, param, MemoryUtil.memAddress(value));
    }

    public static native long nZSTD_CCtx_setPledgedSrcSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setPledgedSrcSize(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="unsigned long long") long pledgedSrcSize) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_setPledgedSrcSize(cctx, pledgedSrcSize);
    }

    public static native long nZSTD_CCtx_loadDictionary(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_loadDictionary(@NativeType(value="ZSTD_CCtx *") long cctx, @Nullable @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_loadDictionary(cctx, MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict));
    }

    public static native long nZSTD_CCtx_loadDictionary_byReference(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_loadDictionary_byReference(@NativeType(value="ZSTD_CCtx *") long cctx, @Nullable @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_loadDictionary_byReference(cctx, MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict));
    }

    public static native long nZSTD_CCtx_loadDictionary_advanced(long var0, long var2, long var4, int var6, int var7);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_loadDictionary_advanced(@NativeType(value="ZSTD_CCtx *") long cctx, @Nullable @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_loadDictionary_advanced(cctx, MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict), dictLoadMethod, dictContentType);
    }

    public static native long nZSTD_CCtx_refCDict(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refCDict(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_refCDict(cctx, cdict);
    }

    public static native long nZSTD_CCtx_refPrefix(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refPrefix(@NativeType(value="ZSTD_CCtx *") long cctx, @Nullable @NativeType(value="void const *") ByteBuffer prefix) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_refPrefix(cctx, MemoryUtil.memAddressSafe(prefix), Checks.remainingSafe(prefix));
    }

    public static native long nZSTD_CCtx_refPrefix_advanced(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refPrefix_advanced(@NativeType(value="ZSTD_CCtx *") long cctx, @Nullable @NativeType(value="void const *") ByteBuffer prefix, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_refPrefix_advanced(cctx, MemoryUtil.memAddressSafe(prefix), Checks.remainingSafe(prefix), dictContentType);
    }

    public static native void nZSTD_CCtx_reset(long var0);

    public static void ZSTD_CCtx_reset(@NativeType(value="ZSTD_CCtx *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        ZstdX.nZSTD_CCtx_reset(cctx);
    }

    public static native long nZSTD_CCtx_resetParameters(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_resetParameters(@NativeType(value="ZSTD_CCtx *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_CCtx_resetParameters(cctx);
    }

    public static native long nZSTD_compress_generic(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_compress_generic(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output, @NativeType(value="ZSTD_inBuffer *") ZSTDInBuffer input, @NativeType(value="ZSTD_EndDirective") int endOp) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            ZSTDOutBuffer.validate(output.address());
            ZSTDInBuffer.validate(input.address());
        }
        return ZstdX.nZSTD_compress_generic(cctx, output.address(), input.address(), endOp);
    }

    public static native long nZSTD_compress_generic_simpleArgs(long var0, long var2, long var4, long var6, long var8, long var10, long var12, int var14);

    @NativeType(value="size_t")
    public static long ZSTD_compress_generic_simpleArgs(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="size_t *") PointerBuffer dstPos, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="size_t *") PointerBuffer srcPos, @NativeType(value="ZSTD_EndDirective") int endOp) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            Checks.check(dstPos, 1);
            Checks.check(srcPos, 1);
        }
        return ZstdX.nZSTD_compress_generic_simpleArgs(cctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(dstPos), MemoryUtil.memAddress(src), src.remaining(), MemoryUtil.memAddress(srcPos), endOp);
    }

    @NativeType(value="ZSTD_CCtx_params *")
    public static native long ZSTD_createCCtxParams();

    public static native long nZSTD_freeCCtxParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeCCtxParams(@NativeType(value="ZSTD_CCtx_params *") long params) {
        if (Checks.CHECKS) {
            Checks.check(params);
        }
        return ZstdX.nZSTD_freeCCtxParams(params);
    }

    public static native long nZSTD_CCtxParams_reset(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_reset(@NativeType(value="ZSTD_CCtx_params *") long params) {
        if (Checks.CHECKS) {
            Checks.check(params);
        }
        return ZstdX.nZSTD_CCtxParams_reset(params);
    }

    public static native long nZSTD_CCtxParams_init(long var0, int var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_init(@NativeType(value="ZSTD_CCtx_params *") long cctxParams, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(cctxParams);
        }
        return ZstdX.nZSTD_CCtxParams_init(cctxParams, compressionLevel);
    }

    public static native long nZSTD_CCtxParam_setParameter(long var0, int var2, int var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParam_setParameter(@NativeType(value="ZSTD_CCtx_params *") long params, @NativeType(value="ZSTD_cParameter") int param, @NativeType(value="unsigned int") int value) {
        if (Checks.CHECKS) {
            Checks.check(params);
        }
        return ZstdX.nZSTD_CCtxParam_setParameter(params, param, value);
    }

    public static native long nZSTD_CCtxParam_getParameter(long var0, int var2, long var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParam_getParameter(@NativeType(value="ZSTD_CCtx_params *") long params, @NativeType(value="ZSTD_cParameter") int param, @NativeType(value="unsigned *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(params);
            Checks.check((Buffer)value, 1);
        }
        return ZstdX.nZSTD_CCtxParam_getParameter(params, param, MemoryUtil.memAddress(value));
    }

    public static native long nZSTD_CCtx_setParametersUsingCCtxParams(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setParametersUsingCCtxParams(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_CCtx_params const *") long params) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            Checks.check(params);
        }
        return ZstdX.nZSTD_CCtx_setParametersUsingCCtxParams(cctx, params);
    }

    public static native long nZSTD_DCtx_loadDictionary(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_loadDictionary(@NativeType(value="ZSTD_DCtx *") long dctx, @Nullable @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_loadDictionary(dctx, MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict));
    }

    public static native long nZSTD_DCtx_loadDictionary_byReference(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_loadDictionary_byReference(@NativeType(value="ZSTD_DCtx *") long dctx, @Nullable @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_loadDictionary_byReference(dctx, MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict));
    }

    public static native long nZSTD_DCtx_loadDictionary_advanced(long var0, long var2, long var4, int var6, int var7);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_loadDictionary_advanced(@NativeType(value="ZSTD_DCtx *") long dctx, @Nullable @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_loadDictionary_advanced(dctx, MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict), dictLoadMethod, dictContentType);
    }

    public static native long nZSTD_DCtx_refDDict(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_refDDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            Checks.check(ddict);
        }
        return ZstdX.nZSTD_DCtx_refDDict(dctx, ddict);
    }

    public static native long nZSTD_DCtx_refPrefix(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_refPrefix(@NativeType(value="ZSTD_DCtx *") long dctx, @Nullable @NativeType(value="void const *") ByteBuffer prefix) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_refPrefix(dctx, MemoryUtil.memAddressSafe(prefix), Checks.remainingSafe(prefix));
    }

    public static native long nZSTD_DCtx_refPrefix_advanced(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_refPrefix_advanced(@NativeType(value="ZSTD_DCtx *") long dctx, @Nullable @NativeType(value="void const *") ByteBuffer prefix, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_refPrefix_advanced(dctx, MemoryUtil.memAddressSafe(prefix), Checks.remainingSafe(prefix), dictContentType);
    }

    public static native long nZSTD_DCtx_setMaxWindowSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_setMaxWindowSize(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="size_t") long maxWindowSize) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_setMaxWindowSize(dctx, maxWindowSize);
    }

    public static native long nZSTD_DCtx_setFormat(long var0, int var2);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_setFormat(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_format_e") int format) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_DCtx_setFormat(dctx, format);
    }

    public static native long nZSTD_getFrameHeader_advanced(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_getFrameHeader_advanced(@NativeType(value="ZSTD_frameHeader *") ZSTDFrameHeader zfhPtr, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="ZSTD_format_e") int format) {
        return ZstdX.nZSTD_getFrameHeader_advanced(zfhPtr.address(), MemoryUtil.memAddress(src), src.remaining(), format);
    }

    public static native long nZSTD_decompress_generic(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_decompress_generic(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output, @NativeType(value="ZSTD_inBuffer *") ZSTDInBuffer input) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            ZSTDOutBuffer.validate(output.address());
            ZSTDInBuffer.validate(input.address());
        }
        return ZstdX.nZSTD_decompress_generic(dctx, output.address(), input.address());
    }

    public static native long nZSTD_decompress_generic_simpleArgs(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long ZSTD_decompress_generic_simpleArgs(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="size_t *") PointerBuffer dstPos, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="size_t *") PointerBuffer srcPos) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            Checks.check(dstPos, 1);
            Checks.check(srcPos, 1);
        }
        return ZstdX.nZSTD_decompress_generic_simpleArgs(dctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(dstPos), MemoryUtil.memAddress(src), src.remaining(), MemoryUtil.memAddress(srcPos));
    }

    public static native void nZSTD_DCtx_reset(long var0);

    public static void ZSTD_DCtx_reset(@NativeType(value="ZSTD_DCtx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        ZstdX.nZSTD_DCtx_reset(dctx);
    }

    public static native long nZSTD_getBlockSize(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_getBlockSize(@NativeType(value="ZSTD_CCtx const *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_getBlockSize(cctx);
    }

    public static native long nZSTD_compressBlock(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_compressBlock(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return ZstdX.nZSTD_compressBlock(cctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_decompressBlock(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_decompressBlock(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_decompressBlock(dctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_insertBlock(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_insertBlock(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") ByteBuffer blockStart) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return ZstdX.nZSTD_insertBlock(dctx, MemoryUtil.memAddress(blockStart), blockStart.remaining());
    }

    static {
        LibZstd.initialize();
        ZSTD_defaultCMem = ZstdX.ZSTD_defaultCMem();
    }
}

