/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.zstd.LibZstd;
import org.lwjgl.util.zstd.ZSTDInBuffer;
import org.lwjgl.util.zstd.ZSTDOutBuffer;

public class Zstd {
    public static final int ZSTD_VERSION_MAJOR = 1;
    public static final int ZSTD_VERSION_MINOR = 3;
    public static final int ZSTD_VERSION_RELEASE = 5;
    public static final int ZSTD_VERSION_NUMBER = 10305;
    public static final String ZSTD_VERSION_STRING = "1.3.5";
    public static final long ZSTD_CONTENTSIZE_UNKNOWN = -1L;
    public static final long ZSTD_CONTENTSIZE_ERROR = -2L;
    public static final int ZSTD_CLEVEL_DEFAULT = 3;

    protected Zstd() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="unsigned")
    public static native int ZSTD_versionNumber();

    public static native long nZSTD_versionString();

    @NativeType(value="char const *")
    public static String ZSTD_versionString() {
        long __result = Zstd.nZSTD_versionString();
        return MemoryUtil.memASCII(__result);
    }

    public static native long nZSTD_compress(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="size_t")
    public static long ZSTD_compress(@NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, int compressionLevel) {
        return Zstd.nZSTD_compress(MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), compressionLevel);
    }

    public static native long nZSTD_decompress(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long ZSTD_decompress(@NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        return Zstd.nZSTD_decompress(MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_getFrameContentSize(long var0, long var2);

    @NativeType(value="unsigned long long")
    public static long ZSTD_getFrameContentSize(@NativeType(value="void const *") ByteBuffer src) {
        return Zstd.nZSTD_getFrameContentSize(MemoryUtil.memAddress(src), src.remaining());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_compressBound(@NativeType(value="size_t") long var0);

    public static native int nZSTD_isError(long var0);

    @NativeType(value="unsigned int")
    public static boolean ZSTD_isError(@NativeType(value="size_t") long code) {
        return Zstd.nZSTD_isError(code) != 0;
    }

    public static native long nZSTD_getErrorName(long var0);

    @NativeType(value="char const *")
    public static String ZSTD_getErrorName(@NativeType(value="size_t") long code) {
        long __result = Zstd.nZSTD_getErrorName(code);
        return MemoryUtil.memASCII(__result);
    }

    public static native int ZSTD_maxCLevel();

    @NativeType(value="ZSTD_CCtx *")
    public static native long ZSTD_createCCtx();

    public static native long nZSTD_freeCCtx(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeCCtx(@NativeType(value="ZSTD_CCtx *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return Zstd.nZSTD_freeCCtx(cctx);
    }

    public static native long nZSTD_compressCCtx(long var0, long var2, long var4, long var6, long var8, int var10);

    @NativeType(value="size_t")
    public static long ZSTD_compressCCtx(@NativeType(value="ZSTD_CCtx *") long ctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return Zstd.nZSTD_compressCCtx(ctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), compressionLevel);
    }

    @NativeType(value="ZSTD_DCtx *")
    public static native long ZSTD_createDCtx();

    public static native long nZSTD_freeDCtx(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeDCtx(@NativeType(value="ZSTD_DCtx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return Zstd.nZSTD_freeDCtx(dctx);
    }

    public static native long nZSTD_decompressDCtx(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_decompressDCtx(@NativeType(value="ZSTD_DCtx *") long ctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return Zstd.nZSTD_decompressDCtx(ctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining());
    }

    public static native long nZSTD_compress_usingDict(long var0, long var2, long var4, long var6, long var8, long var10, long var12, int var14);

    @NativeType(value="size_t")
    public static long ZSTD_compress_usingDict(@NativeType(value="ZSTD_CCtx *") long ctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @Nullable @NativeType(value="void const *") ByteBuffer dict, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return Zstd.nZSTD_compress_usingDict(ctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict), compressionLevel);
    }

    public static native long nZSTD_decompress_usingDict(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long ZSTD_decompress_usingDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @Nullable @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return Zstd.nZSTD_decompress_usingDict(dctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), MemoryUtil.memAddressSafe(dict), Checks.remainingSafe(dict));
    }

    public static native long nZSTD_createCDict(long var0, long var2, int var4);

    @NativeType(value="ZSTD_CDict *")
    public static long ZSTD_createCDict(@NativeType(value="void const *") ByteBuffer dictBuffer, int compressionLevel) {
        return Zstd.nZSTD_createCDict(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), compressionLevel);
    }

    public static native long nZSTD_freeCDict(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeCDict(@NativeType(value="ZSTD_CDict *") long CDict) {
        if (Checks.CHECKS) {
            Checks.check(CDict);
        }
        return Zstd.nZSTD_freeCDict(CDict);
    }

    public static native long nZSTD_compress_usingCDict(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long ZSTD_compress_usingCDict(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="ZSTD_CDict const *") long cdict) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            Checks.check(cdict);
        }
        return Zstd.nZSTD_compress_usingCDict(cctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), cdict);
    }

    public static native long nZSTD_createDDict(long var0, long var2);

    @NativeType(value="ZSTD_DDict *")
    public static long ZSTD_createDDict(@NativeType(value="void const *") ByteBuffer dictBuffer) {
        return Zstd.nZSTD_createDDict(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining());
    }

    public static native long nZSTD_freeDDict(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeDDict(@NativeType(value="ZSTD_DDict *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check(ddict);
        }
        return Zstd.nZSTD_freeDDict(ddict);
    }

    public static native long nZSTD_decompress_usingDDict(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long ZSTD_decompress_usingDDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            Checks.check(ddict);
        }
        return Zstd.nZSTD_decompress_usingDDict(dctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), ddict);
    }

    @NativeType(value="ZSTD_CStream *")
    public static native long ZSTD_createCStream();

    public static native long nZSTD_freeCStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeCStream(@NativeType(value="ZSTD_CStream *") long zcs) {
        if (Checks.CHECKS) {
            Checks.check(zcs);
        }
        return Zstd.nZSTD_freeCStream(zcs);
    }

    public static native long nZSTD_initCStream(long var0, int var2);

    @NativeType(value="size_t")
    public static long ZSTD_initCStream(@NativeType(value="ZSTD_CStream *") long zcs, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(zcs);
        }
        return Zstd.nZSTD_initCStream(zcs, compressionLevel);
    }

    public static native long nZSTD_compressStream(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_compressStream(@NativeType(value="ZSTD_CStream *") long zcs, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output, @NativeType(value="ZSTD_inBuffer *") ZSTDInBuffer input) {
        if (Checks.CHECKS) {
            Checks.check(zcs);
            ZSTDOutBuffer.validate(output.address());
            ZSTDInBuffer.validate(input.address());
        }
        return Zstd.nZSTD_compressStream(zcs, output.address(), input.address());
    }

    public static native long nZSTD_flushStream(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_flushStream(@NativeType(value="ZSTD_CStream *") long zcs, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output) {
        if (Checks.CHECKS) {
            Checks.check(zcs);
            ZSTDOutBuffer.validate(output.address());
        }
        return Zstd.nZSTD_flushStream(zcs, output.address());
    }

    public static native long nZSTD_endStream(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_endStream(@NativeType(value="ZSTD_CStream *") long zcs, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output) {
        if (Checks.CHECKS) {
            Checks.check(zcs);
            ZSTDOutBuffer.validate(output.address());
        }
        return Zstd.nZSTD_endStream(zcs, output.address());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_CStreamInSize();

    @NativeType(value="size_t")
    public static native long ZSTD_CStreamOutSize();

    @NativeType(value="ZSTD_DStream *")
    public static native long ZSTD_createDStream();

    public static native long nZSTD_freeDStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_freeDStream(@NativeType(value="ZSTD_DStream *") long zds) {
        if (Checks.CHECKS) {
            Checks.check(zds);
        }
        return Zstd.nZSTD_freeDStream(zds);
    }

    public static native long nZSTD_initDStream(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_initDStream(@NativeType(value="ZSTD_DStream *") long zds) {
        if (Checks.CHECKS) {
            Checks.check(zds);
        }
        return Zstd.nZSTD_initDStream(zds);
    }

    public static native long nZSTD_decompressStream(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_decompressStream(@NativeType(value="ZSTD_DStream *") long zds, @NativeType(value="ZSTD_outBuffer *") ZSTDOutBuffer output, @NativeType(value="ZSTD_inBuffer *") ZSTDInBuffer input) {
        if (Checks.CHECKS) {
            Checks.check(zds);
            ZSTDOutBuffer.validate(output.address());
            ZSTDInBuffer.validate(input.address());
        }
        return Zstd.nZSTD_decompressStream(zds, output.address(), input.address());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_DStreamInSize();

    @NativeType(value="size_t")
    public static native long ZSTD_DStreamOutSize();

    public static long ZSTD_COMPRESSBOUND(long srcSize) {
        return srcSize + (srcSize >> 8) + (srcSize < 131072L ? 131072L - srcSize >> 11 : 0L);
    }

    static {
        LibZstd.initialize();
    }
}

