/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameProgression")
public class ZSTDFrameProgression
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INGESTED;
    public static final int CONSUMED;
    public static final int PRODUCED;

    ZSTDFrameProgression(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public ZSTDFrameProgression(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ZSTDFrameProgression.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long ingested() {
        return ZSTDFrameProgression.ningested(this.address());
    }

    @NativeType(value="unsigned long long")
    public long consumed() {
        return ZSTDFrameProgression.nconsumed(this.address());
    }

    @NativeType(value="unsigned long long")
    public long produced() {
        return ZSTDFrameProgression.nproduced(this.address());
    }

    public static ZSTDFrameProgression malloc() {
        return ZSTDFrameProgression.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDFrameProgression calloc() {
        return ZSTDFrameProgression.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDFrameProgression create() {
        return new ZSTDFrameProgression(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ZSTDFrameProgression create(long address) {
        return new ZSTDFrameProgression(address, null);
    }

    @Nullable
    public static ZSTDFrameProgression createSafe(long address) {
        return address == 0L ? null : ZSTDFrameProgression.create(address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDFrameProgression.create(ZSTDFrameProgression.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDFrameProgression.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(ZSTDFrameProgression.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDFrameProgression.create(address, capacity);
    }

    public static ZSTDFrameProgression mallocStack() {
        return ZSTDFrameProgression.mallocStack(MemoryStack.stackGet());
    }

    public static ZSTDFrameProgression callocStack() {
        return ZSTDFrameProgression.callocStack(MemoryStack.stackGet());
    }

    public static ZSTDFrameProgression mallocStack(MemoryStack stack) {
        return ZSTDFrameProgression.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDFrameProgression callocStack(MemoryStack stack) {
        return ZSTDFrameProgression.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameProgression.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZSTDFrameProgression.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameProgression.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameProgression.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ningested(long struct) {
        return MemoryUtil.memGetLong(struct + (long)INGESTED);
    }

    public static long nconsumed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CONSUMED);
    }

    public static long nproduced(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PRODUCED);
    }

    static {
        Struct.Layout layout = ZSTDFrameProgression.__struct(ZSTDFrameProgression.__member(8), ZSTDFrameProgression.__member(8), ZSTDFrameProgression.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INGESTED = layout.offsetof(0);
        CONSUMED = layout.offsetof(1);
        PRODUCED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameProgression, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ZSTDFrameProgression newInstance(long address) {
            return new ZSTDFrameProgression(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned long long")
        public long ingested() {
            return ZSTDFrameProgression.ningested(this.address());
        }

        @NativeType(value="unsigned long long")
        public long consumed() {
            return ZSTDFrameProgression.nconsumed(this.address());
        }

        @NativeType(value="unsigned long long")
        public long produced() {
            return ZSTDFrameProgression.nproduced(this.address());
        }
    }
}

