/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_canonical_t")
public class XXH64Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    XXH64Canonical(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public XXH64Canonical(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), XXH64Canonical.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[8]")
    public ByteBuffer digest() {
        return XXH64Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH64Canonical.ndigest(this.address(), index);
    }

    public static XXH64Canonical malloc() {
        return XXH64Canonical.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XXH64Canonical calloc() {
        return XXH64Canonical.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XXH64Canonical create() {
        return new XXH64Canonical(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static XXH64Canonical create(long address) {
        return new XXH64Canonical(address, null);
    }

    @Nullable
    public static XXH64Canonical createSafe(long address) {
        return address == 0L ? null : XXH64Canonical.create(address);
    }

    public static Buffer malloc(int capacity) {
        return XXH64Canonical.create(XXH64Canonical.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH64Canonical.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(XXH64Canonical.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XXH64Canonical.create(address, capacity);
    }

    public static XXH64Canonical mallocStack() {
        return XXH64Canonical.mallocStack(MemoryStack.stackGet());
    }

    public static XXH64Canonical callocStack() {
        return XXH64Canonical.callocStack(MemoryStack.stackGet());
    }

    public static XXH64Canonical mallocStack(MemoryStack stack) {
        return XXH64Canonical.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64Canonical callocStack(MemoryStack stack) {
        return XXH64Canonical.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH64Canonical.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH64Canonical.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DIGEST, 8);
    }

    public static byte ndigest(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DIGEST + Checks.check(index, 8) * 1L);
    }

    static {
        Struct.Layout layout = XXH64Canonical.__struct(XXH64Canonical.__array(1, 8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH64Canonical, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected XXH64Canonical newInstance(long address) {
            return new XXH64Canonical(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned char[8]")
        public ByteBuffer digest() {
            return XXH64Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH64Canonical.ndigest(this.address(), index);
        }
    }
}

