/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.nfd.LibNFD;
import org.lwjgl.util.nfd.NFDPathSet;

public class NativeFileDialog {
    public static final int NFD_ERROR = 0;
    public static final int NFD_OKAY = 1;
    public static final int NFD_CANCEL = 2;

    protected NativeFileDialog() {
        throw new UnsupportedOperationException();
    }

    public static native int nNFD_OpenDialog(long var0, long var2, long var4);

    @NativeType(value="nfdresult_t")
    public static int NFD_OpenDialog(@Nullable @NativeType(value="nfdchar_t const *") ByteBuffer filterList, @Nullable @NativeType(value="nfdchar_t const *") ByteBuffer defaultPath, @NativeType(value="nfdchar_t **") PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(filterList);
            Checks.checkNT1Safe(defaultPath);
            Checks.check(outPath, 1);
        }
        return NativeFileDialog.nNFD_OpenDialog(MemoryUtil.memAddressSafe(filterList), MemoryUtil.memAddressSafe(defaultPath), MemoryUtil.memAddress(outPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nfdresult_t")
    public static int NFD_OpenDialog(@Nullable @NativeType(value="nfdchar_t const *") CharSequence filterList, @Nullable @NativeType(value="nfdchar_t const *") CharSequence defaultPath, @NativeType(value="nfdchar_t **") PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.check(outPath, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filterListEncoded = stack.UTF8Safe(filterList);
            ByteBuffer defaultPathEncoded = stack.UTF8Safe(defaultPath);
            int n = NativeFileDialog.nNFD_OpenDialog(MemoryUtil.memAddressSafe(filterListEncoded), MemoryUtil.memAddressSafe(defaultPathEncoded), MemoryUtil.memAddress(outPath));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nNFD_OpenDialogMultiple(long var0, long var2, long var4);

    @NativeType(value="nfdresult_t")
    public static int NFD_OpenDialogMultiple(@Nullable @NativeType(value="nfdchar_t const *") ByteBuffer filterList, @Nullable @NativeType(value="nfdchar_t const *") ByteBuffer defaultPath, @NativeType(value="nfdpathset_t *") NFDPathSet outPaths) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(filterList);
            Checks.checkNT1Safe(defaultPath);
        }
        return NativeFileDialog.nNFD_OpenDialogMultiple(MemoryUtil.memAddressSafe(filterList), MemoryUtil.memAddressSafe(defaultPath), outPaths.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nfdresult_t")
    public static int NFD_OpenDialogMultiple(@Nullable @NativeType(value="nfdchar_t const *") CharSequence filterList, @Nullable @NativeType(value="nfdchar_t const *") CharSequence defaultPath, @NativeType(value="nfdpathset_t *") NFDPathSet outPaths) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filterListEncoded = stack.UTF8Safe(filterList);
            ByteBuffer defaultPathEncoded = stack.UTF8Safe(defaultPath);
            int n = NativeFileDialog.nNFD_OpenDialogMultiple(MemoryUtil.memAddressSafe(filterListEncoded), MemoryUtil.memAddressSafe(defaultPathEncoded), outPaths.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nNFD_SaveDialog(long var0, long var2, long var4);

    @NativeType(value="nfdresult_t")
    public static int NFD_SaveDialog(@Nullable @NativeType(value="nfdchar_t const *") ByteBuffer filterList, @Nullable @NativeType(value="nfdchar_t const *") ByteBuffer defaultPath, @NativeType(value="nfdchar_t **") PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(filterList);
            Checks.checkNT1Safe(defaultPath);
            Checks.check(outPath, 1);
        }
        return NativeFileDialog.nNFD_SaveDialog(MemoryUtil.memAddressSafe(filterList), MemoryUtil.memAddressSafe(defaultPath), MemoryUtil.memAddress(outPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nfdresult_t")
    public static int NFD_SaveDialog(@Nullable @NativeType(value="nfdchar_t const *") CharSequence filterList, @Nullable @NativeType(value="nfdchar_t const *") CharSequence defaultPath, @NativeType(value="nfdchar_t **") PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.check(outPath, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filterListEncoded = stack.UTF8Safe(filterList);
            ByteBuffer defaultPathEncoded = stack.UTF8Safe(defaultPath);
            int n = NativeFileDialog.nNFD_SaveDialog(MemoryUtil.memAddressSafe(filterListEncoded), MemoryUtil.memAddressSafe(defaultPathEncoded), MemoryUtil.memAddress(outPath));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nNFD_PickFolder(long var0, long var2);

    @NativeType(value="nfdresult_t")
    public static int NFD_PickFolder(@Nullable @NativeType(value="nfdchar_t const *") ByteBuffer defaultPath, @NativeType(value="nfdchar_t **") PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(defaultPath);
            Checks.check(outPath, 1);
        }
        return NativeFileDialog.nNFD_PickFolder(MemoryUtil.memAddressSafe(defaultPath), MemoryUtil.memAddress(outPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nfdresult_t")
    public static int NFD_PickFolder(@Nullable @NativeType(value="nfdchar_t const *") CharSequence defaultPath, @NativeType(value="nfdchar_t **") PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.check(outPath, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer defaultPathEncoded = stack.UTF8Safe(defaultPath);
            int n = NativeFileDialog.nNFD_PickFolder(MemoryUtil.memAddressSafe(defaultPathEncoded), MemoryUtil.memAddress(outPath));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nNFD_GetError();

    @Nullable
    @NativeType(value="char const *")
    public static String NFD_GetError() {
        long __result = NativeFileDialog.nNFD_GetError();
        return MemoryUtil.memASCIISafe(__result);
    }

    public static native long nNFD_PathSet_GetCount(long var0);

    @NativeType(value="size_t")
    public static long NFD_PathSet_GetCount(@NativeType(value="nfdpathset_t const *") NFDPathSet pathSet) {
        return NativeFileDialog.nNFD_PathSet_GetCount(pathSet.address());
    }

    public static native long nNFD_PathSet_GetPath(long var0, long var2);

    @Nullable
    @NativeType(value="nfdchar_t *")
    public static String NFD_PathSet_GetPath(@NativeType(value="nfdpathset_t const *") NFDPathSet pathSet, @NativeType(value="size_t") long index) {
        long __result = NativeFileDialog.nNFD_PathSet_GetPath(pathSet.address(), index);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native void nNFD_PathSet_Free(long var0);

    public static void NFD_PathSet_Free(@NativeType(value="nfdpathset_t *") NFDPathSet pathSet) {
        NativeFileDialog.nNFD_PathSet_Free(pathSet.address());
    }

    public static native void nNFD_Free(long var0);

    public static void NFD_Free(@NativeType(value="void *") ByteBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)outPath, 1);
        }
        NativeFileDialog.nNFD_Free(MemoryUtil.memAddress(outPath));
    }

    static {
        LibNFD.initialize();
    }
}

