/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4F_decompressOptions_t")
public class LZ4FDecompressOptions
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STABLEDST;
    public static final int RESERVED;

    LZ4FDecompressOptions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public LZ4FDecompressOptions(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), LZ4FDecompressOptions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int stableDst() {
        return LZ4FDecompressOptions.nstableDst(this.address());
    }

    @NativeType(value="unsigned[3]")
    public IntBuffer reserved() {
        return LZ4FDecompressOptions.nreserved(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved(int index) {
        return LZ4FDecompressOptions.nreserved(this.address(), index);
    }

    public LZ4FDecompressOptions stableDst(@NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nstableDst(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
        LZ4FDecompressOptions.nreserved(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions reserved(int index, @NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nreserved(this.address(), index, value);
        return this;
    }

    public LZ4FDecompressOptions set(int stableDst, IntBuffer reserved) {
        this.stableDst(stableDst);
        this.reserved(reserved);
        return this;
    }

    public LZ4FDecompressOptions set(LZ4FDecompressOptions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LZ4FDecompressOptions malloc() {
        return LZ4FDecompressOptions.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LZ4FDecompressOptions calloc() {
        return LZ4FDecompressOptions.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LZ4FDecompressOptions create() {
        return new LZ4FDecompressOptions(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static LZ4FDecompressOptions create(long address) {
        return new LZ4FDecompressOptions(address, null);
    }

    @Nullable
    public static LZ4FDecompressOptions createSafe(long address) {
        return address == 0L ? null : LZ4FDecompressOptions.create(address);
    }

    public static Buffer malloc(int capacity) {
        return LZ4FDecompressOptions.create(LZ4FDecompressOptions.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LZ4FDecompressOptions.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(LZ4FDecompressOptions.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4FDecompressOptions.create(address, capacity);
    }

    public static LZ4FDecompressOptions mallocStack() {
        return LZ4FDecompressOptions.mallocStack(MemoryStack.stackGet());
    }

    public static LZ4FDecompressOptions callocStack() {
        return LZ4FDecompressOptions.callocStack(MemoryStack.stackGet());
    }

    public static LZ4FDecompressOptions mallocStack(MemoryStack stack) {
        return LZ4FDecompressOptions.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LZ4FDecompressOptions callocStack(MemoryStack stack) {
        return LZ4FDecompressOptions.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return LZ4FDecompressOptions.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return LZ4FDecompressOptions.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstableDst(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STABLEDST);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 3);
    }

    public static int nreserved(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED + Checks.check(index, 3) * 4L);
    }

    public static void nstableDst(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STABLEDST, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED + Checks.check(index, 3) * 4L, value);
    }

    static {
        Struct.Layout layout = LZ4FDecompressOptions.__struct(LZ4FDecompressOptions.__member(4), LZ4FDecompressOptions.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STABLEDST = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4FDecompressOptions, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected LZ4FDecompressOptions newInstance(long address) {
            return new LZ4FDecompressOptions(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned")
        public int stableDst() {
            return LZ4FDecompressOptions.nstableDst(this.address());
        }

        @NativeType(value="unsigned[3]")
        public IntBuffer reserved() {
            return LZ4FDecompressOptions.nreserved(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved(int index) {
            return LZ4FDecompressOptions.nreserved(this.address(), index);
        }

        public Buffer stableDst(@NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nstableDst(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
            LZ4FDecompressOptions.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nreserved(this.address(), index, value);
            return this;
        }
    }
}

