/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct rpmalloc_thread_statistics_t")
public class RPmallocThreadStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIVE;
    public static final int SIZECACHE;
    public static final int SPANCACHE;
    public static final int DEFERRED;
    public static final int THREAD_TO_GLOBAL;
    public static final int GLOBAL_TO_THREAD;

    RPmallocThreadStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public RPmallocThreadStatistics(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RPmallocThreadStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long active() {
        return RPmallocThreadStatistics.nactive(this.address());
    }

    @NativeType(value="size_t")
    public long sizecache() {
        return RPmallocThreadStatistics.nsizecache(this.address());
    }

    @NativeType(value="size_t")
    public long spancache() {
        return RPmallocThreadStatistics.nspancache(this.address());
    }

    @NativeType(value="size_t")
    public long deferred() {
        return RPmallocThreadStatistics.ndeferred(this.address());
    }

    @NativeType(value="size_t")
    public long thread_to_global() {
        return RPmallocThreadStatistics.nthread_to_global(this.address());
    }

    @NativeType(value="size_t")
    public long global_to_thread() {
        return RPmallocThreadStatistics.nglobal_to_thread(this.address());
    }

    public static RPmallocThreadStatistics malloc() {
        return RPmallocThreadStatistics.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RPmallocThreadStatistics calloc() {
        return RPmallocThreadStatistics.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RPmallocThreadStatistics create() {
        return new RPmallocThreadStatistics(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RPmallocThreadStatistics create(long address) {
        return new RPmallocThreadStatistics(address, null);
    }

    @Nullable
    public static RPmallocThreadStatistics createSafe(long address) {
        return address == 0L ? null : RPmallocThreadStatistics.create(address);
    }

    public static Buffer malloc(int capacity) {
        return RPmallocThreadStatistics.create(RPmallocThreadStatistics.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RPmallocThreadStatistics.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(RPmallocThreadStatistics.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : RPmallocThreadStatistics.create(address, capacity);
    }

    public static RPmallocThreadStatistics mallocStack() {
        return RPmallocThreadStatistics.mallocStack(MemoryStack.stackGet());
    }

    public static RPmallocThreadStatistics callocStack() {
        return RPmallocThreadStatistics.callocStack(MemoryStack.stackGet());
    }

    public static RPmallocThreadStatistics mallocStack(MemoryStack stack) {
        return RPmallocThreadStatistics.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RPmallocThreadStatistics callocStack(MemoryStack stack) {
        return RPmallocThreadStatistics.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RPmallocThreadStatistics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RPmallocThreadStatistics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RPmallocThreadStatistics.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RPmallocThreadStatistics.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nactive(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTIVE);
    }

    public static long nsizecache(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZECACHE);
    }

    public static long nspancache(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPANCACHE);
    }

    public static long ndeferred(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DEFERRED);
    }

    public static long nthread_to_global(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)THREAD_TO_GLOBAL);
    }

    public static long nglobal_to_thread(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GLOBAL_TO_THREAD);
    }

    static {
        Struct.Layout layout = RPmallocThreadStatistics.__struct(RPmallocThreadStatistics.__member(POINTER_SIZE), RPmallocThreadStatistics.__member(POINTER_SIZE), RPmallocThreadStatistics.__member(POINTER_SIZE), RPmallocThreadStatistics.__member(POINTER_SIZE), RPmallocThreadStatistics.__member(POINTER_SIZE), RPmallocThreadStatistics.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIVE = layout.offsetof(0);
        SIZECACHE = layout.offsetof(1);
        SPANCACHE = layout.offsetof(2);
        DEFERRED = layout.offsetof(3);
        THREAD_TO_GLOBAL = layout.offsetof(4);
        GLOBAL_TO_THREAD = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<RPmallocThreadStatistics, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RPmallocThreadStatistics newInstance(long address) {
            return new RPmallocThreadStatistics(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long active() {
            return RPmallocThreadStatistics.nactive(this.address());
        }

        @NativeType(value="size_t")
        public long sizecache() {
            return RPmallocThreadStatistics.nsizecache(this.address());
        }

        @NativeType(value="size_t")
        public long spancache() {
            return RPmallocThreadStatistics.nspancache(this.address());
        }

        @NativeType(value="size_t")
        public long deferred() {
            return RPmallocThreadStatistics.ndeferred(this.address());
        }

        @NativeType(value="size_t")
        public long thread_to_global() {
            return RPmallocThreadStatistics.nthread_to_global(this.address());
        }

        @NativeType(value="size_t")
        public long global_to_thread() {
            return RPmallocThreadStatistics.nglobal_to_thread(this.address());
        }
    }
}

