/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.rpmalloc.LibRPmalloc;
import org.lwjgl.system.rpmalloc.RPmalloc;

public class RPmallocAllocator
implements MemoryUtil.MemoryAllocator {
    @Override
    public long getMalloc() {
        return RPmalloc.rpmalloc_address();
    }

    @Override
    public long getCalloc() {
        return RPmalloc.rpcalloc_address();
    }

    @Override
    public long getRealloc() {
        return RPmalloc.rprealloc_address();
    }

    @Override
    public long getFree() {
        return RPmalloc.rpfree_address();
    }

    @Override
    public long getAlignedAlloc() {
        return RPmalloc.rpaligned_alloc_address();
    }

    @Override
    public long getAlignedFree() {
        return RPmalloc.rpfree_address();
    }

    @Override
    public long malloc(long size) {
        return RPmalloc.nrpmalloc(size);
    }

    @Override
    public long calloc(long num, long size) {
        return RPmalloc.nrpcalloc(num, size);
    }

    @Override
    public long realloc(long ptr, long size) {
        return RPmalloc.nrprealloc(ptr, size);
    }

    @Override
    public void free(long ptr) {
        RPmalloc.nrpfree(ptr);
    }

    @Override
    public long aligned_alloc(long alignment, long size) {
        return RPmalloc.nrpaligned_alloc(alignment, size);
    }

    @Override
    public void aligned_free(long ptr) {
        RPmalloc.nrpfree(ptr);
    }

    static {
        LibRPmalloc.initialize();
        RPmalloc.rpmalloc_initialize();
    }
}

