/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

final class MemoryTextDecoding {
    private MemoryTextDecoding() {
    }

    static String decodeASCII(ByteBuffer buffer, int length, int offset) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)buffer.get(offset + i);
        }
        return new String(chars);
    }

    static String decodeUTF8(ByteBuffer buffer, int length, int offset) {
        byte c;
        int position;
        if (length <= 0) {
            return "";
        }
        char[] string = new char[length];
        int i = 0;
        int limit = offset + length;
        for (position = offset; position < limit && (c = buffer.get(position)) >= 0; ++position) {
            string[i++] = (char)c;
        }
        while (position < limit) {
            byte b2;
            byte b1;
            byte b0;
            if (0 <= (b0 = buffer.get(position++))) {
                string[i++] = (char)b0;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                b1 = buffer.get(position++);
                MemoryTextDecoding.checkMalformed2(b1);
                string[i++] = (char)(b0 << 6 ^ b1 ^ 0xF80);
                continue;
            }
            if (b0 >> 4 == -2) {
                b1 = buffer.get(position++);
                b2 = buffer.get(position++);
                MemoryTextDecoding.checkMalformed3(b0, b1, b2);
                string[i++] = MemoryTextDecoding.checkSurrogate((char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80)));
                continue;
            }
            if (b0 >> 3 == -2) {
                b1 = buffer.get(position++);
                b2 = buffer.get(position++);
                byte b3 = buffer.get(position++);
                int cp = b0 << 18 ^ b1 << 12 ^ b2 << 6 ^ (b3 ^ 0x381F80);
                MemoryTextDecoding.checkMalformed4(b1, b2, b3, cp);
                string[i++] = (char)((cp >>> 10) + 55296 - 64);
                string[i++] = (char)((cp & 0x3FF) + 56320);
                continue;
            }
            if (!Checks.DEBUG) continue;
            throw new RuntimeException("Malformed character sequence");
        }
        return new String(string, 0, i);
    }

    private static void checkMalformed2(int b1) {
        if (Checks.DEBUG && (b1 & 0xC0) != 128) {
            throw new RuntimeException("Malformed character sequence");
        }
    }

    private static void checkMalformed3(int b0, int b1, int b2) {
        if (Checks.DEBUG && (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128)) {
            throw new RuntimeException("Malformed character sequence");
        }
    }

    private static char checkSurrogate(char c) {
        if (Checks.DEBUG && '\ud800' <= c && c <= '\udfff') {
            throw new RuntimeException("Malformed character sequence");
        }
        return c;
    }

    private static void checkMalformed4(int b1, int b2, int b3, int cp) {
        if (Checks.DEBUG && ((b1 & 0xC0) != 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(cp))) {
            throw new RuntimeException("Malformed character sequence");
        }
    }

    static String decodeUTF16(ByteBuffer buffer, int length, int offset) {
        if (length <= 0) {
            return "";
        }
        return MemoryUtil.memCharBuffer(MemoryUtil.memAddress(buffer) + (long)offset, length).toString();
    }
}

