/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrViewScaleDesc")
public class OVRViewScaleDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HMDTOEYEPOSE;
    public static final int HMDSPACETOWORLDSCALEINMETERS;

    OVRViewScaleDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRViewScaleDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRViewScaleDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer HmdToEyePose() {
        return OVRViewScaleDesc.nHmdToEyePose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef HmdToEyePose(int index) {
        return OVRViewScaleDesc.nHmdToEyePose(this.address(), index);
    }

    public float HmdSpaceToWorldScaleInMeters() {
        return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
    }

    public OVRViewScaleDesc HmdToEyePose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRViewScaleDesc.nHmdToEyePose(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc HmdToEyePose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRViewScaleDesc.nHmdToEyePose(this.address(), index, value);
        return this;
    }

    public OVRViewScaleDesc HmdSpaceToWorldScaleInMeters(float value) {
        OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc set(OVRPosef.Buffer HmdToEyePose, float HmdSpaceToWorldScaleInMeters) {
        this.HmdToEyePose(HmdToEyePose);
        this.HmdSpaceToWorldScaleInMeters(HmdSpaceToWorldScaleInMeters);
        return this;
    }

    public OVRViewScaleDesc set(OVRViewScaleDesc src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRViewScaleDesc malloc() {
        return OVRViewScaleDesc.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRViewScaleDesc calloc() {
        return OVRViewScaleDesc.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRViewScaleDesc create() {
        return new OVRViewScaleDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRViewScaleDesc create(long address) {
        return new OVRViewScaleDesc(address, null);
    }

    @Nullable
    public static OVRViewScaleDesc createSafe(long address) {
        return address == 0L ? null : OVRViewScaleDesc.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRViewScaleDesc.create(OVRViewScaleDesc.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRViewScaleDesc.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRViewScaleDesc.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRViewScaleDesc.create(address, capacity);
    }

    public static OVRViewScaleDesc mallocStack() {
        return OVRViewScaleDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRViewScaleDesc callocStack() {
        return OVRViewScaleDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRViewScaleDesc mallocStack(MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRViewScaleDesc callocStack(MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRViewScaleDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRViewScaleDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPosef.Buffer nHmdToEyePose(long struct) {
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE, 2);
    }

    public static OVRPosef nHmdToEyePose(long struct, int index) {
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF);
    }

    public static float nHmdSpaceToWorldScaleInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HMDSPACETOWORLDSCALEINMETERS);
    }

    public static void nHmdToEyePose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)HMDTOEYEPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nHmdToEyePose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HMDTOEYEPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF, OVRPosef.SIZEOF);
    }

    public static void nHmdSpaceToWorldScaleInMeters(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HMDSPACETOWORLDSCALEINMETERS, value);
    }

    static {
        Struct.Layout layout = OVRViewScaleDesc.__struct(OVRViewScaleDesc.__array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, 2), OVRViewScaleDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HMDTOEYEPOSE = layout.offsetof(0);
        HMDSPACETOWORLDSCALEINMETERS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRViewScaleDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRViewScaleDesc newInstance(long address) {
            return new OVRViewScaleDesc(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer HmdToEyePose() {
            return OVRViewScaleDesc.nHmdToEyePose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef HmdToEyePose(int index) {
            return OVRViewScaleDesc.nHmdToEyePose(this.address(), index);
        }

        public float HmdSpaceToWorldScaleInMeters() {
            return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
        }

        public Buffer HmdToEyePose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRViewScaleDesc.nHmdToEyePose(this.address(), value);
            return this;
        }

        public Buffer HmdToEyePose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRViewScaleDesc.nHmdToEyePose(this.address(), index, value);
            return this;
        }

        public Buffer HmdSpaceToWorldScaleInMeters(float value) {
            OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
            return this;
        }
    }
}

