/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nullable;
import org.lwjgl.ovr.LibOVR;
import org.lwjgl.ovr.OVRAudioChannelData;
import org.lwjgl.ovr.OVRDetectResult;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRHapticsClip;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRTimewarpProjectionDesc;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class OVRUtil {
    public static final int ovrProjection_None = 0;
    public static final int ovrProjection_LeftHanded = 1;
    public static final int ovrProjection_FarLessThanNear = 2;
    public static final int ovrProjection_FarClipAtInfinity = 4;
    public static final int ovrProjection_ClipRangeOpenGL = 8;
    public static final int ovrHapticsGenMode_PointSample = 0;
    public static final int ovrHapticsGenMode_Count = 1;

    protected OVRUtil() {
        throw new UnsupportedOperationException();
    }

    public static native void novr_Detect(int var0, long var1);

    @NativeType(value="ovrDetectResult")
    public static OVRDetectResult ovr_Detect(int timeoutMilliseconds, OVRDetectResult __result) {
        OVRUtil.novr_Detect(timeoutMilliseconds, __result.address());
        return __result;
    }

    public static native void novrMatrix4f_Projection(long var0, float var2, float var3, int var4, long var5);

    @NativeType(value="ovrMatrix4f")
    public static OVRMatrix4f ovrMatrix4f_Projection(@NativeType(value="ovrFovPort") OVRFovPort fov, float znear, float zfar, @NativeType(value="unsigned int") int projectionModFlags, OVRMatrix4f __result) {
        OVRUtil.novrMatrix4f_Projection(fov.address(), znear, zfar, projectionModFlags, __result.address());
        return __result;
    }

    public static native void novrTimewarpProjectionDesc_FromProjection(long var0, int var2, long var3);

    @NativeType(value="ovrTimewarpProjectionDesc")
    public static OVRTimewarpProjectionDesc ovrTimewarpProjectionDesc_FromProjection(@NativeType(value="ovrMatrix4f") OVRMatrix4f projection, @NativeType(value="unsigned int") int projectionModFlags, OVRTimewarpProjectionDesc __result) {
        OVRUtil.novrTimewarpProjectionDesc_FromProjection(projection.address(), projectionModFlags, __result.address());
        return __result;
    }

    public static native void novrMatrix4f_OrthoSubProjection(long var0, long var2, float var4, float var5, long var6);

    @NativeType(value="ovrMatrix4f")
    public static OVRMatrix4f ovrMatrix4f_OrthoSubProjection(@NativeType(value="ovrMatrix4f") OVRMatrix4f projection, @NativeType(value="ovrVector2f") OVRVector2f orthoScale, float orthoDistance, float HmdToEyeOffsetX, OVRMatrix4f __result) {
        OVRUtil.novrMatrix4f_OrthoSubProjection(projection.address(), orthoScale.address(), orthoDistance, HmdToEyeOffsetX, __result.address());
        return __result;
    }

    public static native void novr_CalcEyePoses(long var0, long var2, long var4);

    public static void ovr_CalcEyePoses(@NativeType(value="ovrPosef") OVRPosef headPose, @NativeType(value="ovrPosef const *") OVRPosef.Buffer HmdToEyePose, @NativeType(value="ovrPosef *") OVRPosef.Buffer outEyePoses) {
        if (Checks.CHECKS) {
            Checks.check(HmdToEyePose, 2);
            Checks.check(outEyePoses, 2);
        }
        OVRUtil.novr_CalcEyePoses(headPose.address(), HmdToEyePose.address(), outEyePoses.address());
    }

    public static native void novr_GetEyePoses(long var0, long var2, boolean var4, long var5, long var7, long var9);

    public static void ovr_GetEyePoses(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex, @NativeType(value="ovrBool") boolean latencyMarker, @NativeType(value="ovrPosef const *") OVRPosef.Buffer HmdToEyePose, @NativeType(value="ovrPosef *") OVRPosef.Buffer outEyePoses, @Nullable @NativeType(value="double *") DoubleBuffer outSensorSampleTime) {
        if (Checks.CHECKS) {
            Checks.check(session);
            Checks.check(HmdToEyePose, 2);
            Checks.check(outEyePoses, 2);
            Checks.checkSafe((Buffer)outSensorSampleTime, 1);
        }
        OVRUtil.novr_GetEyePoses(session, frameIndex, latencyMarker, HmdToEyePose.address(), outEyePoses.address(), MemoryUtil.memAddressSafe(outSensorSampleTime));
    }

    public static native void novrPosef_FlipHandedness(long var0, long var2);

    public static void ovrPosef_FlipHandedness(@NativeType(value="ovrPosef const *") OVRPosef inPose, @NativeType(value="ovrPosef *") OVRPosef outPose) {
        OVRUtil.novrPosef_FlipHandedness(inPose.address(), outPose.address());
    }

    public static native int novr_ReadWavFromBuffer(long var0, long var2, int var4, int var5);

    @NativeType(value="ovrResult")
    public static int ovr_ReadWavFromBuffer(@NativeType(value="ovrAudioChannelData *") OVRAudioChannelData outAudioChannel, @NativeType(value="void const *") ByteBuffer inputData, int stereoChannelToUse) {
        return OVRUtil.novr_ReadWavFromBuffer(outAudioChannel.address(), MemoryUtil.memAddress(inputData), inputData.remaining(), stereoChannelToUse);
    }

    public static native int novr_GenHapticsFromAudioData(long var0, long var2, int var4);

    @NativeType(value="ovrResult")
    public static int ovr_GenHapticsFromAudioData(@NativeType(value="ovrHapticsClip *") OVRHapticsClip outHapticsClip, @NativeType(value="ovrAudioChannelData const *") OVRAudioChannelData audioChannel, @NativeType(value="ovrHapticsGenMode") int genMode) {
        return OVRUtil.novr_GenHapticsFromAudioData(outHapticsClip.address(), audioChannel.address(), genMode);
    }

    public static native void novr_ReleaseAudioChannelData(long var0);

    public static void ovr_ReleaseAudioChannelData(@NativeType(value="ovrAudioChannelData *") OVRAudioChannelData audioChannel) {
        OVRUtil.novr_ReleaseAudioChannelData(audioChannel.address());
    }

    public static native void novr_ReleaseHapticsClip(long var0);

    public static void ovr_ReleaseHapticsClip(@NativeType(value="ovrHapticsClip *") OVRHapticsClip hapticsClip) {
        OVRUtil.novr_ReleaseHapticsClip(hapticsClip.address());
    }

    public static native void novr_GetEyePoses(long var0, long var2, boolean var4, long var5, long var7, double[] var9);

    public static void ovr_GetEyePoses(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex, @NativeType(value="ovrBool") boolean latencyMarker, @NativeType(value="ovrPosef const *") OVRPosef.Buffer HmdToEyePose, @NativeType(value="ovrPosef *") OVRPosef.Buffer outEyePoses, @Nullable @NativeType(value="double *") double[] outSensorSampleTime) {
        if (Checks.CHECKS) {
            Checks.check(session);
            Checks.check(HmdToEyePose, 2);
            Checks.check(outEyePoses, 2);
            Checks.checkSafe(outSensorSampleTime, 1);
        }
        OVRUtil.novr_GetEyePoses(session, frameIndex, latencyMarker, HmdToEyePose.address(), outEyePoses.address(), outSensorSampleTime);
    }

    static {
        LibOVR.initialize();
    }
}

