/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrSizei")
public class OVRSizei
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int H;

    OVRSizei(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRSizei(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRSizei.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return OVRSizei.nw(this.address());
    }

    public int h() {
        return OVRSizei.nh(this.address());
    }

    public OVRSizei w(int value) {
        OVRSizei.nw(this.address(), value);
        return this;
    }

    public OVRSizei h(int value) {
        OVRSizei.nh(this.address(), value);
        return this;
    }

    public OVRSizei set(int w, int h) {
        this.w(w);
        this.h(h);
        return this;
    }

    public OVRSizei set(OVRSizei src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRSizei malloc() {
        return OVRSizei.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRSizei calloc() {
        return OVRSizei.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRSizei create() {
        return new OVRSizei(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRSizei create(long address) {
        return new OVRSizei(address, null);
    }

    @Nullable
    public static OVRSizei createSafe(long address) {
        return address == 0L ? null : OVRSizei.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRSizei.create(OVRSizei.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRSizei.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRSizei.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRSizei.create(address, capacity);
    }

    public static OVRSizei mallocStack() {
        return OVRSizei.mallocStack(MemoryStack.stackGet());
    }

    public static OVRSizei callocStack() {
        return OVRSizei.callocStack(MemoryStack.stackGet());
    }

    public static OVRSizei mallocStack(MemoryStack stack) {
        return OVRSizei.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRSizei callocStack(MemoryStack stack) {
        return OVRSizei.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRSizei.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRSizei.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSizei.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSizei.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)H);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)H, value);
    }

    static {
        Struct.Layout layout = OVRSizei.__struct(OVRSizei.__member(4), OVRSizei.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        H = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRSizei, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRSizei newInstance(long address) {
            return new OVRSizei(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public int w() {
            return OVRSizei.nw(this.address());
        }

        public int h() {
            return OVRSizei.nh(this.address());
        }

        public Buffer w(int value) {
            OVRSizei.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            OVRSizei.nh(this.address(), value);
            return this;
        }
    }
}

