/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerCylinder")
public class OVRLayerCylinder
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int CYLINDERPOSECENTER;
    public static final int CYLINDERRADIUS;
    public static final int CYLINDERANGLE;
    public static final int CYLINDERASPECTRATIO;

    OVRLayerCylinder(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerCylinder(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRLayerCylinder.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerCylinder.nHeader(this.address());
    }

    public OVRLayerCylinder Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture() {
        return OVRLayerCylinder.nColorTexture(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport() {
        return OVRLayerCylinder.nViewport(this.address());
    }

    public OVRLayerCylinder Viewport(Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    @NativeType(value="ovrPosef")
    public OVRPosef CylinderPoseCenter() {
        return OVRLayerCylinder.nCylinderPoseCenter(this.address());
    }

    public OVRLayerCylinder CylinderPoseCenter(Consumer<OVRPosef> consumer) {
        consumer.accept(this.CylinderPoseCenter());
        return this;
    }

    public float CylinderRadius() {
        return OVRLayerCylinder.nCylinderRadius(this.address());
    }

    public float CylinderAngle() {
        return OVRLayerCylinder.nCylinderAngle(this.address());
    }

    public float CylinderAspectRatio() {
        return OVRLayerCylinder.nCylinderAspectRatio(this.address());
    }

    public OVRLayerCylinder Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerCylinder.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerCylinder ColorTexture(@NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerCylinder.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerCylinder Viewport(@NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerCylinder.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerCylinder CylinderPoseCenter(@NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerCylinder.nCylinderPoseCenter(this.address(), value);
        return this;
    }

    public OVRLayerCylinder CylinderRadius(float value) {
        OVRLayerCylinder.nCylinderRadius(this.address(), value);
        return this;
    }

    public OVRLayerCylinder CylinderAngle(float value) {
        OVRLayerCylinder.nCylinderAngle(this.address(), value);
        return this;
    }

    public OVRLayerCylinder CylinderAspectRatio(float value) {
        OVRLayerCylinder.nCylinderAspectRatio(this.address(), value);
        return this;
    }

    public OVRLayerCylinder set(OVRLayerHeader Header, long ColorTexture, OVRRecti Viewport, OVRPosef CylinderPoseCenter, float CylinderRadius, float CylinderAngle, float CylinderAspectRatio) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.CylinderPoseCenter(CylinderPoseCenter);
        this.CylinderRadius(CylinderRadius);
        this.CylinderAngle(CylinderAngle);
        this.CylinderAspectRatio(CylinderAspectRatio);
        return this;
    }

    public OVRLayerCylinder set(OVRLayerCylinder src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerCylinder malloc() {
        return OVRLayerCylinder.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRLayerCylinder calloc() {
        return OVRLayerCylinder.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRLayerCylinder create() {
        return new OVRLayerCylinder(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRLayerCylinder create(long address) {
        return new OVRLayerCylinder(address, null);
    }

    @Nullable
    public static OVRLayerCylinder createSafe(long address) {
        return address == 0L ? null : OVRLayerCylinder.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerCylinder.create(OVRLayerCylinder.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerCylinder.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerCylinder.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRLayerCylinder.create(address, capacity);
    }

    public static OVRLayerCylinder mallocStack() {
        return OVRLayerCylinder.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerCylinder callocStack() {
        return OVRLayerCylinder.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerCylinder mallocStack(MemoryStack stack) {
        return OVRLayerCylinder.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerCylinder callocStack(MemoryStack stack) {
        return OVRLayerCylinder.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerCylinder.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerCylinder.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerCylinder.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerCylinder.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static long nColorTexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE);
    }

    public static OVRRecti nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT);
    }

    public static OVRPosef nCylinderPoseCenter(long struct) {
        return OVRPosef.create(struct + (long)CYLINDERPOSECENTER);
    }

    public static float nCylinderRadius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CYLINDERRADIUS);
    }

    public static float nCylinderAngle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CYLINDERANGLE);
    }

    public static float nCylinderAspectRatio(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CYLINDERASPECTRATIO);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE, Checks.check(value));
    }

    public static void nViewport(long struct, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, OVRRecti.SIZEOF);
    }

    public static void nCylinderPoseCenter(long struct, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CYLINDERPOSECENTER, OVRPosef.SIZEOF);
    }

    public static void nCylinderRadius(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CYLINDERRADIUS, value);
    }

    public static void nCylinderAngle(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CYLINDERANGLE, value);
    }

    public static void nCylinderAspectRatio(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CYLINDERASPECTRATIO, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerCylinder.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerCylinder.__struct(OVRLayerCylinder.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF), OVRLayerCylinder.__member(POINTER_SIZE), OVRLayerCylinder.__member(OVRRecti.SIZEOF, OVRRecti.ALIGNOF), OVRLayerCylinder.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF), OVRLayerCylinder.__member(4), OVRLayerCylinder.__member(4), OVRLayerCylinder.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        CYLINDERPOSECENTER = layout.offsetof(3);
        CYLINDERRADIUS = layout.offsetof(4);
        CYLINDERANGLE = layout.offsetof(5);
        CYLINDERASPECTRATIO = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerCylinder, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRLayerCylinder newInstance(long address) {
            return new OVRLayerCylinder(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerCylinder.nHeader(this.address());
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture() {
            return OVRLayerCylinder.nColorTexture(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport() {
            return OVRLayerCylinder.nViewport(this.address());
        }

        public Buffer Viewport(Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        @NativeType(value="ovrPosef")
        public OVRPosef CylinderPoseCenter() {
            return OVRLayerCylinder.nCylinderPoseCenter(this.address());
        }

        public Buffer CylinderPoseCenter(Consumer<OVRPosef> consumer) {
            consumer.accept(this.CylinderPoseCenter());
            return this;
        }

        public float CylinderRadius() {
            return OVRLayerCylinder.nCylinderRadius(this.address());
        }

        public float CylinderAngle() {
            return OVRLayerCylinder.nCylinderAngle(this.address());
        }

        public float CylinderAspectRatio() {
            return OVRLayerCylinder.nCylinderAspectRatio(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerCylinder.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerCylinder.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerCylinder.nViewport(this.address(), value);
            return this;
        }

        public Buffer CylinderPoseCenter(@NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerCylinder.nCylinderPoseCenter(this.address(), value);
            return this;
        }

        public Buffer CylinderRadius(float value) {
            OVRLayerCylinder.nCylinderRadius(this.address(), value);
            return this;
        }

        public Buffer CylinderAngle(float value) {
            OVRLayerCylinder.nCylinderAngle(this.address(), value);
            return this;
        }

        public Buffer CylinderAspectRatio(float value) {
            OVRLayerCylinder.nCylinderAspectRatio(this.address(), value);
            return this;
        }
    }
}

