/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureBounds_t")
public class VRTextureBounds
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UMIN;
    public static final int VMIN;
    public static final int UMAX;
    public static final int VMAX;

    VRTextureBounds(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VRTextureBounds(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VRTextureBounds.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float uMin() {
        return VRTextureBounds.nuMin(this.address());
    }

    public float vMin() {
        return VRTextureBounds.nvMin(this.address());
    }

    public float uMax() {
        return VRTextureBounds.nuMax(this.address());
    }

    public float vMax() {
        return VRTextureBounds.nvMax(this.address());
    }

    public VRTextureBounds uMin(float value) {
        VRTextureBounds.nuMin(this.address(), value);
        return this;
    }

    public VRTextureBounds vMin(float value) {
        VRTextureBounds.nvMin(this.address(), value);
        return this;
    }

    public VRTextureBounds uMax(float value) {
        VRTextureBounds.nuMax(this.address(), value);
        return this;
    }

    public VRTextureBounds vMax(float value) {
        VRTextureBounds.nvMax(this.address(), value);
        return this;
    }

    public VRTextureBounds set(float uMin, float vMin, float uMax, float vMax) {
        this.uMin(uMin);
        this.vMin(vMin);
        this.uMax(uMax);
        this.vMax(vMax);
        return this;
    }

    public VRTextureBounds set(VRTextureBounds src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRTextureBounds malloc() {
        return VRTextureBounds.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VRTextureBounds calloc() {
        return VRTextureBounds.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VRTextureBounds create() {
        return new VRTextureBounds(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VRTextureBounds create(long address) {
        return new VRTextureBounds(address, null);
    }

    @Nullable
    public static VRTextureBounds createSafe(long address) {
        return address == 0L ? null : VRTextureBounds.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VRTextureBounds.create(VRTextureBounds.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VRTextureBounds.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VRTextureBounds.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VRTextureBounds.create(address, capacity);
    }

    public static VRTextureBounds mallocStack() {
        return VRTextureBounds.mallocStack(MemoryStack.stackGet());
    }

    public static VRTextureBounds callocStack() {
        return VRTextureBounds.callocStack(MemoryStack.stackGet());
    }

    public static VRTextureBounds mallocStack(MemoryStack stack) {
        return VRTextureBounds.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRTextureBounds callocStack(MemoryStack stack) {
        return VRTextureBounds.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VRTextureBounds.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VRTextureBounds.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureBounds.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureBounds.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nuMin(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UMIN);
    }

    public static float nvMin(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VMIN);
    }

    public static float nuMax(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UMAX);
    }

    public static float nvMax(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VMAX);
    }

    public static void nuMin(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UMIN, value);
    }

    public static void nvMin(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VMIN, value);
    }

    public static void nuMax(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UMAX, value);
    }

    public static void nvMax(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VMAX, value);
    }

    static {
        Struct.Layout layout = VRTextureBounds.__struct(VRTextureBounds.__member(4), VRTextureBounds.__member(4), VRTextureBounds.__member(4), VRTextureBounds.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UMIN = layout.offsetof(0);
        VMIN = layout.offsetof(1);
        UMAX = layout.offsetof(2);
        VMAX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRTextureBounds, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VRTextureBounds newInstance(long address) {
            return new VRTextureBounds(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float uMin() {
            return VRTextureBounds.nuMin(this.address());
        }

        public float vMin() {
            return VRTextureBounds.nvMin(this.address());
        }

        public float uMax() {
            return VRTextureBounds.nuMax(this.address());
        }

        public float vMax() {
            return VRTextureBounds.nvMax(this.address());
        }

        public Buffer uMin(float value) {
            VRTextureBounds.nuMin(this.address(), value);
            return this;
        }

        public Buffer vMin(float value) {
            VRTextureBounds.nvMin(this.address(), value);
            return this;
        }

        public Buffer uMax(float value) {
            VRTextureBounds.nuMax(this.address(), value);
            return this;
        }

        public Buffer vMax(float value) {
            VRTextureBounds.nvMax(this.address(), value);
            return this;
        }
    }
}

