/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.DistortionCoordinates;
import org.lwjgl.openvr.HiddenAreaMesh;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VRControllerState;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRSystem {
    protected VRSystem() {
        throw new UnsupportedOperationException();
    }

    public static void nVRSystem_GetRecommendedRenderTargetSize(long pnWidth, long pnHeight) {
        long __functionAddress = OpenVR.VRSystem.GetRecommendedRenderTargetSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, pnWidth, pnHeight);
    }

    public static void VRSystem_GetRecommendedRenderTargetSize(@NativeType(value="uint32_t *") IntBuffer pnWidth, @NativeType(value="uint32_t *") IntBuffer pnHeight) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnWidth, 1);
            Checks.check((Buffer)pnHeight, 1);
        }
        VRSystem.nVRSystem_GetRecommendedRenderTargetSize(MemoryUtil.memAddress(pnWidth), MemoryUtil.memAddress(pnHeight));
    }

    public static native void nVRSystem_GetProjectionMatrix(long var0, int var2, float var3, float var4, long var5);

    public static void nVRSystem_GetProjectionMatrix(int eEye, float fNearZ, float fFarZ, long __result) {
        long __functionAddress = OpenVR.VRSystem.GetProjectionMatrix;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        VRSystem.nVRSystem_GetProjectionMatrix(__functionAddress, eEye, fNearZ, fFarZ, __result);
    }

    @NativeType(value="HmdMatrix44_t")
    public static HmdMatrix44 VRSystem_GetProjectionMatrix(@NativeType(value="EVREye") int eEye, float fNearZ, float fFarZ, HmdMatrix44 __result) {
        VRSystem.nVRSystem_GetProjectionMatrix(eEye, fNearZ, fFarZ, __result.address());
        return __result;
    }

    public static void nVRSystem_GetProjectionRaw(int eEye, long pfLeft, long pfRight, long pfTop, long pfBottom) {
        long __functionAddress = OpenVR.VRSystem.GetProjectionRaw;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, eEye, pfLeft, pfRight, pfTop, pfBottom);
    }

    public static void VRSystem_GetProjectionRaw(@NativeType(value="EVREye") int eEye, @NativeType(value="float *") FloatBuffer pfLeft, @NativeType(value="float *") FloatBuffer pfRight, @NativeType(value="float *") FloatBuffer pfTop, @NativeType(value="float *") FloatBuffer pfBottom) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfLeft, 1);
            Checks.check((Buffer)pfRight, 1);
            Checks.check((Buffer)pfTop, 1);
            Checks.check((Buffer)pfBottom, 1);
        }
        VRSystem.nVRSystem_GetProjectionRaw(eEye, MemoryUtil.memAddress(pfLeft), MemoryUtil.memAddress(pfRight), MemoryUtil.memAddress(pfTop), MemoryUtil.memAddress(pfBottom));
    }

    public static boolean nVRSystem_ComputeDistortion(int eEye, float fU, float fV, long pDistortionCoordinates) {
        long __functionAddress = OpenVR.VRSystem.ComputeDistortion;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, eEye, fU, fV, pDistortionCoordinates);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_ComputeDistortion(@NativeType(value="EVREye") int eEye, float fU, float fV, @NativeType(value="DistortionCoordinates_t *") DistortionCoordinates pDistortionCoordinates) {
        return VRSystem.nVRSystem_ComputeDistortion(eEye, fU, fV, pDistortionCoordinates.address());
    }

    public static native void nVRSystem_GetEyeToHeadTransform(long var0, int var2, long var3);

    public static void nVRSystem_GetEyeToHeadTransform(int eEye, long __result) {
        long __functionAddress = OpenVR.VRSystem.GetEyeToHeadTransform;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        VRSystem.nVRSystem_GetEyeToHeadTransform(__functionAddress, eEye, __result);
    }

    @NativeType(value="HmdMatrix34_t")
    public static HmdMatrix34 VRSystem_GetEyeToHeadTransform(@NativeType(value="EVREye") int eEye, HmdMatrix34 __result) {
        VRSystem.nVRSystem_GetEyeToHeadTransform(eEye, __result.address());
        return __result;
    }

    public static boolean nVRSystem_GetTimeSinceLastVsync(long pfSecondsSinceLastVsync, long pulFrameCounter) {
        long __functionAddress = OpenVR.VRSystem.GetTimeSinceLastVsync;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pfSecondsSinceLastVsync, pulFrameCounter);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_GetTimeSinceLastVsync(@NativeType(value="float *") FloatBuffer pfSecondsSinceLastVsync, @NativeType(value="uint64_t *") LongBuffer pulFrameCounter) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfSecondsSinceLastVsync, 1);
            Checks.check((Buffer)pulFrameCounter, 1);
        }
        return VRSystem.nVRSystem_GetTimeSinceLastVsync(MemoryUtil.memAddress(pfSecondsSinceLastVsync), MemoryUtil.memAddress(pulFrameCounter));
    }

    @NativeType(value="int32_t")
    public static int VRSystem_GetD3D9AdapterIndex() {
        long __functionAddress = OpenVR.VRSystem.GetD3D9AdapterIndex;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static void nVRSystem_GetDXGIOutputInfo(long pnAdapterIndex) {
        long __functionAddress = OpenVR.VRSystem.GetDXGIOutputInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pnAdapterIndex);
    }

    public static void VRSystem_GetDXGIOutputInfo(@NativeType(value="int32_t *") IntBuffer pnAdapterIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnAdapterIndex, 1);
        }
        VRSystem.nVRSystem_GetDXGIOutputInfo(MemoryUtil.memAddress(pnAdapterIndex));
    }

    public static void nVRSystem_GetOutputDevice(long pnDevice, int textureType, long pInstance) {
        long __functionAddress = OpenVR.VRSystem.GetOutputDevice;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pInstance);
        }
        JNI.callPPV(__functionAddress, pnDevice, textureType, pInstance);
    }

    public static void VRSystem_GetOutputDevice(@NativeType(value="uint64_t *") LongBuffer pnDevice, @NativeType(value="ETextureType") int textureType, @NativeType(value="VkInstance_T *") long pInstance) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnDevice, 1);
        }
        VRSystem.nVRSystem_GetOutputDevice(MemoryUtil.memAddress(pnDevice), textureType, pInstance);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_IsDisplayOnDesktop() {
        long __functionAddress = OpenVR.VRSystem.IsDisplayOnDesktop;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_SetDisplayVisibility(@NativeType(value="bool") boolean bIsVisibleOnDesktop) {
        long __functionAddress = OpenVR.VRSystem.SetDisplayVisibility;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress, bIsVisibleOnDesktop);
    }

    public static void nVRSystem_GetDeviceToAbsoluteTrackingPose(int eOrigin, float fPredictedSecondsToPhotonsFromNow, long pTrackedDevicePoseArray, int unTrackedDevicePoseArrayCount) {
        long __functionAddress = OpenVR.VRSystem.GetDeviceToAbsoluteTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, eOrigin, fPredictedSecondsToPhotonsFromNow, pTrackedDevicePoseArray, unTrackedDevicePoseArrayCount);
    }

    public static void VRSystem_GetDeviceToAbsoluteTrackingPose(@NativeType(value="ETrackingUniverseOrigin") int eOrigin, float fPredictedSecondsToPhotonsFromNow, @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose.Buffer pTrackedDevicePoseArray) {
        VRSystem.nVRSystem_GetDeviceToAbsoluteTrackingPose(eOrigin, fPredictedSecondsToPhotonsFromNow, pTrackedDevicePoseArray.address(), pTrackedDevicePoseArray.remaining());
    }

    public static void VRSystem_ResetSeatedZeroPose() {
        long __functionAddress = OpenVR.VRSystem.ResetSeatedZeroPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static native void nVRSystem_GetSeatedZeroPoseToStandingAbsoluteTrackingPose(long var0, long var2);

    public static void nVRSystem_GetSeatedZeroPoseToStandingAbsoluteTrackingPose(long __result) {
        long __functionAddress = OpenVR.VRSystem.GetSeatedZeroPoseToStandingAbsoluteTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        VRSystem.nVRSystem_GetSeatedZeroPoseToStandingAbsoluteTrackingPose(__functionAddress, __result);
    }

    @NativeType(value="HmdMatrix34_t")
    public static HmdMatrix34 VRSystem_GetSeatedZeroPoseToStandingAbsoluteTrackingPose(HmdMatrix34 __result) {
        VRSystem.nVRSystem_GetSeatedZeroPoseToStandingAbsoluteTrackingPose(__result.address());
        return __result;
    }

    public static native void nVRSystem_GetRawZeroPoseToStandingAbsoluteTrackingPose(long var0, long var2);

    public static void nVRSystem_GetRawZeroPoseToStandingAbsoluteTrackingPose(long __result) {
        long __functionAddress = OpenVR.VRSystem.GetRawZeroPoseToStandingAbsoluteTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        VRSystem.nVRSystem_GetRawZeroPoseToStandingAbsoluteTrackingPose(__functionAddress, __result);
    }

    @NativeType(value="HmdMatrix34_t")
    public static HmdMatrix34 VRSystem_GetRawZeroPoseToStandingAbsoluteTrackingPose(HmdMatrix34 __result) {
        VRSystem.nVRSystem_GetRawZeroPoseToStandingAbsoluteTrackingPose(__result.address());
        return __result;
    }

    public static int nVRSystem_GetSortedTrackedDeviceIndicesOfClass(int eTrackedDeviceClass, long punTrackedDeviceIndexArray, int unTrackedDeviceIndexArrayCount, int unRelativeToTrackedDeviceIndex) {
        long __functionAddress = OpenVR.VRSystem.GetSortedTrackedDeviceIndicesOfClass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, eTrackedDeviceClass, punTrackedDeviceIndexArray, unTrackedDeviceIndexArrayCount, unRelativeToTrackedDeviceIndex);
    }

    @NativeType(value="uint32_t")
    public static int VRSystem_GetSortedTrackedDeviceIndicesOfClass(@NativeType(value="ETrackedDeviceClass") int eTrackedDeviceClass, @Nullable @NativeType(value="TrackedDeviceIndex_t *") IntBuffer punTrackedDeviceIndexArray, @NativeType(value="TrackedDeviceIndex_t") int unRelativeToTrackedDeviceIndex) {
        return VRSystem.nVRSystem_GetSortedTrackedDeviceIndicesOfClass(eTrackedDeviceClass, MemoryUtil.memAddressSafe(punTrackedDeviceIndexArray), Checks.remainingSafe(punTrackedDeviceIndexArray), unRelativeToTrackedDeviceIndex);
    }

    @NativeType(value="EDeviceActivityLevel")
    public static int VRSystem_GetTrackedDeviceActivityLevel(@NativeType(value="TrackedDeviceIndex_t") int unDeviceId) {
        long __functionAddress = OpenVR.VRSystem.GetTrackedDeviceActivityLevel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, unDeviceId);
    }

    public static void nVRSystem_ApplyTransform(long pOutputPose, long pTrackedDevicePose, long pTransform) {
        long __functionAddress = OpenVR.VRSystem.ApplyTransform;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, pOutputPose, pTrackedDevicePose, pTransform);
    }

    public static void VRSystem_ApplyTransform(@NativeType(value="TrackedDevicePose_t *") TrackedDevicePose pOutputPose, @NativeType(value="TrackedDevicePose_t const *") TrackedDevicePose pTrackedDevicePose, @NativeType(value="HmdMatrix34_t const *") HmdMatrix34 pTransform) {
        VRSystem.nVRSystem_ApplyTransform(pOutputPose.address(), pTrackedDevicePose.address(), pTransform.address());
    }

    @NativeType(value="TrackedDeviceIndex_t")
    public static int VRSystem_GetTrackedDeviceIndexForControllerRole(@NativeType(value="ETrackedControllerRole") int unDeviceType) {
        long __functionAddress = OpenVR.VRSystem.GetTrackedDeviceIndexForControllerRole;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, unDeviceType);
    }

    @NativeType(value="ETrackedControllerRole")
    public static int VRSystem_GetControllerRoleForTrackedDeviceIndex(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex) {
        long __functionAddress = OpenVR.VRSystem.GetControllerRoleForTrackedDeviceIndex;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, unDeviceIndex);
    }

    @NativeType(value="ETrackedDeviceClass")
    public static int VRSystem_GetTrackedDeviceClass(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex) {
        long __functionAddress = OpenVR.VRSystem.GetTrackedDeviceClass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, unDeviceIndex);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_IsTrackedDeviceConnected(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex) {
        long __functionAddress = OpenVR.VRSystem.IsTrackedDeviceConnected;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress, unDeviceIndex);
    }

    public static boolean nVRSystem_GetBoolTrackedDeviceProperty(int unDeviceIndex, int prop, long pError) {
        long __functionAddress = OpenVR.VRSystem.GetBoolTrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, unDeviceIndex, prop, pError);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_GetBoolTrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        return VRSystem.nVRSystem_GetBoolTrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddressSafe(pError));
    }

    public static float nVRSystem_GetFloatTrackedDeviceProperty(int unDeviceIndex, int prop, long pError) {
        long __functionAddress = OpenVR.VRSystem.GetFloatTrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPF(__functionAddress, unDeviceIndex, prop, pError);
    }

    public static float VRSystem_GetFloatTrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        return VRSystem.nVRSystem_GetFloatTrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddressSafe(pError));
    }

    public static int nVRSystem_GetInt32TrackedDeviceProperty(int unDeviceIndex, int prop, long pError) {
        long __functionAddress = OpenVR.VRSystem.GetInt32TrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unDeviceIndex, prop, pError);
    }

    @NativeType(value="int32_t")
    public static int VRSystem_GetInt32TrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        return VRSystem.nVRSystem_GetInt32TrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddressSafe(pError));
    }

    public static long nVRSystem_GetUint64TrackedDeviceProperty(int unDeviceIndex, int prop, long pError) {
        long __functionAddress = OpenVR.VRSystem.GetUint64TrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJ(__functionAddress, unDeviceIndex, prop, pError);
    }

    @NativeType(value="uint64_t")
    public static long VRSystem_GetUint64TrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        return VRSystem.nVRSystem_GetUint64TrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddressSafe(pError));
    }

    public static native void nVRSystem_GetMatrix34TrackedDeviceProperty(long var0, int var2, int var3, long var4, long var6);

    public static void nVRSystem_GetMatrix34TrackedDeviceProperty(int unDeviceIndex, int prop, long pError, long __result) {
        long __functionAddress = OpenVR.VRSystem.GetMatrix34TrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        VRSystem.nVRSystem_GetMatrix34TrackedDeviceProperty(__functionAddress, unDeviceIndex, prop, pError, __result);
    }

    @NativeType(value="HmdMatrix34_t")
    public static HmdMatrix34 VRSystem_GetMatrix34TrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError, HmdMatrix34 __result) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        VRSystem.nVRSystem_GetMatrix34TrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddressSafe(pError), __result.address());
        return __result;
    }

    public static int nVRSystem_GetArrayTrackedDeviceProperty(int unDeviceIndex, int prop, int propType, long pBuffer, int unBufferSize, long pError) {
        long __functionAddress = OpenVR.VRSystem.GetArrayTrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, unDeviceIndex, prop, propType, pBuffer, unBufferSize, pError);
    }

    @NativeType(value="uint32_t")
    public static int VRSystem_GetArrayTrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @NativeType(value="PropertyTypeTag_t") int propType, @Nullable @NativeType(value="void *") ByteBuffer pBuffer, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        return VRSystem.nVRSystem_GetArrayTrackedDeviceProperty(unDeviceIndex, prop, propType, MemoryUtil.memAddressSafe(pBuffer), Checks.remainingSafe(pBuffer), MemoryUtil.memAddressSafe(pError));
    }

    public static int nVRSystem_GetStringTrackedDeviceProperty(int unDeviceIndex, int prop, long pchValue, int unBufferSize, long pError) {
        long __functionAddress = OpenVR.VRSystem.GetStringTrackedDeviceProperty;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, unDeviceIndex, prop, pchValue, unBufferSize, pError);
    }

    @NativeType(value="uint32_t")
    public static int VRSystem_GetStringTrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="char *") ByteBuffer pchValue, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        return VRSystem.nVRSystem_GetStringTrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddressSafe(pchValue), Checks.remainingSafe(pchValue), MemoryUtil.memAddressSafe(pError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRSystem_GetStringTrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @NativeType(value="uint32_t") int unBufferSize, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchValue = stack.malloc(unBufferSize);
            int __result = VRSystem.nVRSystem_GetStringTrackedDeviceProperty(unDeviceIndex, prop, MemoryUtil.memAddress(pchValue), unBufferSize, MemoryUtil.memAddressSafe(pError));
            String string = MemoryUtil.memASCII(pchValue, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint32_t")
    public static String VRSystem_GetStringTrackedDeviceProperty(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackedDeviceProperty") int prop, @Nullable @NativeType(value="ETrackedPropertyError *") IntBuffer pError) {
        return VRSystem.VRSystem_GetStringTrackedDeviceProperty(unDeviceIndex, prop, 32768, pError);
    }

    public static long nVRSystem_GetPropErrorNameFromEnum(int error) {
        long __functionAddress = OpenVR.VRSystem.GetPropErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, error);
    }

    @Nullable
    @NativeType(value="char *")
    public static String VRSystem_GetPropErrorNameFromEnum(@NativeType(value="ETrackedPropertyError") int error) {
        long __result = VRSystem.nVRSystem_GetPropErrorNameFromEnum(error);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static boolean nVRSystem_PollNextEvent(long pEvent, int uncbVREvent) {
        long __functionAddress = OpenVR.VRSystem.PollNextEvent;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pEvent, uncbVREvent);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_PollNextEvent(@NativeType(value="VREvent_t *") VREvent pEvent, @NativeType(value="uint32_t") int uncbVREvent) {
        return VRSystem.nVRSystem_PollNextEvent(pEvent.address(), uncbVREvent);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_PollNextEvent(@NativeType(value="VREvent_t *") VREvent pEvent) {
        return VRSystem.nVRSystem_PollNextEvent(pEvent.address(), VREvent.SIZEOF);
    }

    public static boolean nVRSystem_PollNextEventWithPose(int eOrigin, long pEvent, int uncbVREvent, long pTrackedDevicePose) {
        long __functionAddress = OpenVR.VRSystem.PollNextEventWithPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, eOrigin, pEvent, uncbVREvent, pTrackedDevicePose);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_PollNextEventWithPose(@NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="VREvent_t *") VREvent pEvent, @NativeType(value="uint32_t") int uncbVREvent, @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose pTrackedDevicePose) {
        return VRSystem.nVRSystem_PollNextEventWithPose(eOrigin, pEvent.address(), uncbVREvent, pTrackedDevicePose.address());
    }

    @NativeType(value="bool")
    public static boolean VRSystem_PollNextEventWithPose(@NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="VREvent_t *") VREvent pEvent, @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose pTrackedDevicePose) {
        return VRSystem.nVRSystem_PollNextEventWithPose(eOrigin, pEvent.address(), VREvent.SIZEOF, pTrackedDevicePose.address());
    }

    public static long nVRSystem_GetEventTypeNameFromEnum(int eType) {
        long __functionAddress = OpenVR.VRSystem.GetEventTypeNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, eType);
    }

    @Nullable
    @NativeType(value="char *")
    public static String VRSystem_GetEventTypeNameFromEnum(@NativeType(value="EVREventType") int eType) {
        long __result = VRSystem.nVRSystem_GetEventTypeNameFromEnum(eType);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static native void nVRSystem_GetHiddenAreaMesh(long var0, int var2, int var3, long var4);

    public static void nVRSystem_GetHiddenAreaMesh(int eEye, int type, long __result) {
        long __functionAddress = OpenVR.VRSystem.GetHiddenAreaMesh;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        VRSystem.nVRSystem_GetHiddenAreaMesh(__functionAddress, eEye, type, __result);
    }

    @NativeType(value="HiddenAreaMesh_t")
    public static HiddenAreaMesh VRSystem_GetHiddenAreaMesh(@NativeType(value="EVREye") int eEye, @NativeType(value="EHiddenAreaMeshType") int type, HiddenAreaMesh __result) {
        VRSystem.nVRSystem_GetHiddenAreaMesh(eEye, type, __result.address());
        return __result;
    }

    public static boolean nVRSystem_GetControllerState(int unControllerDeviceIndex, long pControllerState, int unControllerStateSize) {
        long __functionAddress = OpenVR.VRSystem.GetControllerState;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, unControllerDeviceIndex, pControllerState, unControllerStateSize);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_GetControllerState(@NativeType(value="TrackedDeviceIndex_t") int unControllerDeviceIndex, @NativeType(value="VRControllerState_t *") VRControllerState pControllerState, @NativeType(value="uint32_t") int unControllerStateSize) {
        return VRSystem.nVRSystem_GetControllerState(unControllerDeviceIndex, pControllerState.address(), unControllerStateSize);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_GetControllerState(@NativeType(value="TrackedDeviceIndex_t") int unControllerDeviceIndex, @NativeType(value="VRControllerState_t *") VRControllerState pControllerState) {
        return VRSystem.nVRSystem_GetControllerState(unControllerDeviceIndex, pControllerState.address(), VRControllerState.SIZEOF);
    }

    public static boolean nVRSystem_GetControllerStateWithPose(int eOrigin, int unControllerDeviceIndex, long pControllerState, int unControllerStateSize, long pTrackedDevicePose) {
        long __functionAddress = OpenVR.VRSystem.GetControllerStateWithPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, eOrigin, unControllerDeviceIndex, pControllerState, unControllerStateSize, pTrackedDevicePose);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_GetControllerStateWithPose(@NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="TrackedDeviceIndex_t") int unControllerDeviceIndex, @NativeType(value="VRControllerState_t *") VRControllerState pControllerState, @NativeType(value="uint32_t") int unControllerStateSize, @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose pTrackedDevicePose) {
        return VRSystem.nVRSystem_GetControllerStateWithPose(eOrigin, unControllerDeviceIndex, pControllerState.address(), unControllerStateSize, pTrackedDevicePose.address());
    }

    public static void VRSystem_TriggerHapticPulse(@NativeType(value="TrackedDeviceIndex_t") int unControllerDeviceIndex, @NativeType(value="uint32_t") int unAxisId, @NativeType(value="unsigned short") short usDurationMicroSec) {
        long __functionAddress = OpenVR.VRSystem.TriggerHapticPulse;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress, unControllerDeviceIndex, unAxisId, usDurationMicroSec);
    }

    public static long nVRSystem_GetButtonIdNameFromEnum(int eButtonId) {
        long __functionAddress = OpenVR.VRSystem.GetButtonIdNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, eButtonId);
    }

    @Nullable
    @NativeType(value="char *")
    public static String VRSystem_GetButtonIdNameFromEnum(@NativeType(value="EVRButtonId") int eButtonId) {
        long __result = VRSystem.nVRSystem_GetButtonIdNameFromEnum(eButtonId);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static long nVRSystem_GetControllerAxisTypeNameFromEnum(int eAxisType) {
        long __functionAddress = OpenVR.VRSystem.GetControllerAxisTypeNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, eAxisType);
    }

    @Nullable
    @NativeType(value="char *")
    public static String VRSystem_GetControllerAxisTypeNameFromEnum(@NativeType(value="EVRControllerAxisType") int eAxisType) {
        long __result = VRSystem.nVRSystem_GetControllerAxisTypeNameFromEnum(eAxisType);
        return MemoryUtil.memASCIISafe(__result);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_IsInputAvailable() {
        long __functionAddress = OpenVR.VRSystem.IsInputAvailable;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_IsSteamVRDrawingControllers() {
        long __functionAddress = OpenVR.VRSystem.IsSteamVRDrawingControllers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_ShouldApplicationPause() {
        long __functionAddress = OpenVR.VRSystem.ShouldApplicationPause;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRSystem_ShouldApplicationReduceRenderingWork() {
        long __functionAddress = OpenVR.VRSystem.ShouldApplicationReduceRenderingWork;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    public static int nVRSystem_DriverDebugRequest(int unDeviceIndex, long pchRequest, long pchResponseBuffer, int unResponseBufferSize) {
        long __functionAddress = OpenVR.VRSystem.DriverDebugRequest;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, unDeviceIndex, pchRequest, pchResponseBuffer, unResponseBufferSize);
    }

    @NativeType(value="uint32_t")
    public static int VRSystem_DriverDebugRequest(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="char const *") ByteBuffer pchRequest, @Nullable @NativeType(value="char *") ByteBuffer pchResponseBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRequest);
        }
        return VRSystem.nVRSystem_DriverDebugRequest(unDeviceIndex, MemoryUtil.memAddress(pchRequest), MemoryUtil.memAddressSafe(pchResponseBuffer), Checks.remainingSafe(pchResponseBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRSystem_DriverDebugRequest(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="char const *") CharSequence pchRequest, @Nullable @NativeType(value="char *") ByteBuffer pchResponseBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRequestEncoded = stack.ASCII(pchRequest);
            int n = VRSystem.nVRSystem_DriverDebugRequest(unDeviceIndex, MemoryUtil.memAddress(pchRequestEncoded), MemoryUtil.memAddressSafe(pchResponseBuffer), Checks.remainingSafe(pchResponseBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRSystem_DriverDebugRequest(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="char const *") CharSequence pchRequest, @NativeType(value="uint32_t") int unResponseBufferSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRequestEncoded = stack.ASCII(pchRequest);
            ByteBuffer pchResponseBuffer = stack.malloc(unResponseBufferSize);
            int __result = VRSystem.nVRSystem_DriverDebugRequest(unDeviceIndex, MemoryUtil.memAddress(pchRequestEncoded), MemoryUtil.memAddress(pchResponseBuffer), unResponseBufferSize);
            String string = MemoryUtil.memASCII(pchResponseBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint32_t")
    public static String VRSystem_DriverDebugRequest(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="char const *") CharSequence pchRequest) {
        return VRSystem.VRSystem_DriverDebugRequest(unDeviceIndex, pchRequest, 32768);
    }

    @NativeType(value="EVRFirmwareError")
    public static int VRSystem_PerformFirmwareUpdate(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex) {
        long __functionAddress = OpenVR.VRSystem.PerformFirmwareUpdate;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, unDeviceIndex);
    }

    public static void VRSystem_AcknowledgeQuit_Exiting() {
        long __functionAddress = OpenVR.VRSystem.AcknowledgeQuit_Exiting;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void VRSystem_AcknowledgeQuit_UserPrompt() {
        long __functionAddress = OpenVR.VRSystem.AcknowledgeQuit_UserPrompt;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    static {
        OpenVR.initialize();
    }
}

