/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_Vertex_t")
public class RenderModelVertex
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOSITION;
    public static final int VNORMAL;
    public static final int RFTEXTURECOORD;

    RenderModelVertex(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public RenderModelVertex(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelVertex.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vPosition() {
        return RenderModelVertex.nvPosition(this.address());
    }

    public RenderModelVertex vPosition(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vPosition());
        return this;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vNormal() {
        return RenderModelVertex.nvNormal(this.address());
    }

    public RenderModelVertex vNormal(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vNormal());
        return this;
    }

    @NativeType(value="float[2]")
    public FloatBuffer rfTextureCoord() {
        return RenderModelVertex.nrfTextureCoord(this.address());
    }

    public float rfTextureCoord(int index) {
        return RenderModelVertex.nrfTextureCoord(this.address(), index);
    }

    public static RenderModelVertex create(long address) {
        return new RenderModelVertex(address, null);
    }

    @Nullable
    public static RenderModelVertex createSafe(long address) {
        return address == 0L ? null : RenderModelVertex.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : RenderModelVertex.create(address, capacity);
    }

    public static HmdVector3 nvPosition(long struct) {
        return HmdVector3.create(struct + (long)VPOSITION);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static FloatBuffer nrfTextureCoord(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)RFTEXTURECOORD, 2);
    }

    public static float nrfTextureCoord(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)RFTEXTURECOORD + Checks.check(index, 2) * 4L);
    }

    static {
        Struct.Layout layout = RenderModelVertex.__struct(RenderModelVertex.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), RenderModelVertex.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), RenderModelVertex.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOSITION = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        RFTEXTURECOORD = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelVertex, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelVertex newInstance(long address) {
            return new RenderModelVertex(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vPosition() {
            return RenderModelVertex.nvPosition(this.address());
        }

        public Buffer vPosition(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vPosition());
            return this;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vNormal() {
            return RenderModelVertex.nvNormal(this.address());
        }

        public Buffer vNormal(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vNormal());
            return this;
        }

        @NativeType(value="float[2]")
        public FloatBuffer rfTextureCoord() {
            return RenderModelVertex.nrfTextureCoord(this.address());
        }

        public float rfTextureCoord(int index) {
            return RenderModelVertex.nrfTextureCoord(this.address(), index);
        }
    }
}

