/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_ComponentState_t")
public class RenderModelComponentState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTRACKINGTOCOMPONENTRENDERMODEL;
    public static final int MTRACKINGTOCOMPONENTLOCAL;
    public static final int UPROPERTIES;

    RenderModelComponentState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public RenderModelComponentState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelComponentState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdMatrix34_t")
    public HmdMatrix34 mTrackingToComponentRenderModel() {
        return RenderModelComponentState.nmTrackingToComponentRenderModel(this.address());
    }

    public RenderModelComponentState mTrackingToComponentRenderModel(Consumer<HmdMatrix34> consumer) {
        consumer.accept(this.mTrackingToComponentRenderModel());
        return this;
    }

    @NativeType(value="HmdMatrix34_t")
    public HmdMatrix34 mTrackingToComponentLocal() {
        return RenderModelComponentState.nmTrackingToComponentLocal(this.address());
    }

    public RenderModelComponentState mTrackingToComponentLocal(Consumer<HmdMatrix34> consumer) {
        consumer.accept(this.mTrackingToComponentLocal());
        return this;
    }

    @NativeType(value="VRComponentProperties")
    public int uProperties() {
        return RenderModelComponentState.nuProperties(this.address());
    }

    public static RenderModelComponentState malloc() {
        return RenderModelComponentState.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RenderModelComponentState calloc() {
        return RenderModelComponentState.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RenderModelComponentState create() {
        return new RenderModelComponentState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModelComponentState create(long address) {
        return new RenderModelComponentState(address, null);
    }

    @Nullable
    public static RenderModelComponentState createSafe(long address) {
        return address == 0L ? null : RenderModelComponentState.create(address);
    }

    public static Buffer malloc(int capacity) {
        return RenderModelComponentState.create(RenderModelComponentState.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModelComponentState.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(RenderModelComponentState.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : RenderModelComponentState.create(address, capacity);
    }

    public static RenderModelComponentState mallocStack() {
        return RenderModelComponentState.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModelComponentState callocStack() {
        return RenderModelComponentState.callocStack(MemoryStack.stackGet());
    }

    public static RenderModelComponentState mallocStack(MemoryStack stack) {
        return RenderModelComponentState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModelComponentState callocStack(MemoryStack stack) {
        return RenderModelComponentState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModelComponentState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModelComponentState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelComponentState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelComponentState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdMatrix34 nmTrackingToComponentRenderModel(long struct) {
        return HmdMatrix34.create(struct + (long)MTRACKINGTOCOMPONENTRENDERMODEL);
    }

    public static HmdMatrix34 nmTrackingToComponentLocal(long struct) {
        return HmdMatrix34.create(struct + (long)MTRACKINGTOCOMPONENTLOCAL);
    }

    public static int nuProperties(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UPROPERTIES);
    }

    static {
        Struct.Layout layout = RenderModelComponentState.__struct(RenderModelComponentState.__member(HmdMatrix34.SIZEOF, HmdMatrix34.ALIGNOF), RenderModelComponentState.__member(HmdMatrix34.SIZEOF, HmdMatrix34.ALIGNOF), RenderModelComponentState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTRACKINGTOCOMPONENTRENDERMODEL = layout.offsetof(0);
        MTRACKINGTOCOMPONENTLOCAL = layout.offsetof(1);
        UPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelComponentState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelComponentState newInstance(long address) {
            return new RenderModelComponentState(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="HmdMatrix34_t")
        public HmdMatrix34 mTrackingToComponentRenderModel() {
            return RenderModelComponentState.nmTrackingToComponentRenderModel(this.address());
        }

        public Buffer mTrackingToComponentRenderModel(Consumer<HmdMatrix34> consumer) {
            consumer.accept(this.mTrackingToComponentRenderModel());
            return this;
        }

        @NativeType(value="HmdMatrix34_t")
        public HmdMatrix34 mTrackingToComponentLocal() {
            return RenderModelComponentState.nmTrackingToComponentLocal(this.address());
        }

        public Buffer mTrackingToComponentLocal(Consumer<HmdMatrix34> consumer) {
            consumer.accept(this.mTrackingToComponentLocal());
            return this;
        }

        @NativeType(value="VRComponentProperties")
        public int uProperties() {
            return RenderModelComponentState.nuProperties(this.address());
        }
    }
}

