/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputPoseActionData_t")
public class InputPoseActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int POSE;

    InputPoseActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public InputPoseActionData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), InputPoseActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputPoseActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputPoseActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose pose() {
        return InputPoseActionData.npose(this.address());
    }

    public InputPoseActionData pose(Consumer<TrackedDevicePose> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public static InputPoseActionData malloc() {
        return InputPoseActionData.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputPoseActionData calloc() {
        return InputPoseActionData.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputPoseActionData create() {
        return new InputPoseActionData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static InputPoseActionData create(long address) {
        return new InputPoseActionData(address, null);
    }

    @Nullable
    public static InputPoseActionData createSafe(long address) {
        return address == 0L ? null : InputPoseActionData.create(address);
    }

    public static Buffer malloc(int capacity) {
        return InputPoseActionData.create(InputPoseActionData.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputPoseActionData.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(InputPoseActionData.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputPoseActionData.create(address, capacity);
    }

    public static InputPoseActionData mallocStack() {
        return InputPoseActionData.mallocStack(MemoryStack.stackGet());
    }

    public static InputPoseActionData callocStack() {
        return InputPoseActionData.callocStack(MemoryStack.stackGet());
    }

    public static InputPoseActionData mallocStack(MemoryStack stack) {
        return InputPoseActionData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputPoseActionData callocStack(MemoryStack stack) {
        return InputPoseActionData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return InputPoseActionData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return InputPoseActionData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputPoseActionData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputPoseActionData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ACTIVEORIGIN);
    }

    public static TrackedDevicePose npose(long struct) {
        return TrackedDevicePose.create(struct + (long)POSE);
    }

    static {
        Struct.Layout layout = InputPoseActionData.__struct(InputPoseActionData.__member(1), InputPoseActionData.__member(8), InputPoseActionData.__member(TrackedDevicePose.SIZEOF, TrackedDevicePose.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        POSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputPoseActionData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected InputPoseActionData newInstance(long address) {
            return new InputPoseActionData(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputPoseActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputPoseActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose pose() {
            return InputPoseActionData.npose(this.address());
        }

        public Buffer pose(Consumer<TrackedDevicePose> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

