/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputOriginInfo_t")
public class InputOriginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEPATH;
    public static final int TRACKEDDEVICEINDEX;
    public static final int RCHRENDERMODELCOMPONENTNAME;

    InputOriginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public InputOriginInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), InputOriginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRInputValueHandle_t")
    public long devicePath() {
        return InputOriginInfo.ndevicePath(this.address());
    }

    @NativeType(value="TrackedDeviceIndex_t")
    public int trackedDeviceIndex() {
        return InputOriginInfo.ntrackedDeviceIndex(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchRenderModelComponentName() {
        return InputOriginInfo.nrchRenderModelComponentName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchRenderModelComponentNameString() {
        return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
    }

    public static InputOriginInfo malloc() {
        return InputOriginInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputOriginInfo calloc() {
        return InputOriginInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputOriginInfo create() {
        return new InputOriginInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static InputOriginInfo create(long address) {
        return new InputOriginInfo(address, null);
    }

    @Nullable
    public static InputOriginInfo createSafe(long address) {
        return address == 0L ? null : InputOriginInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return InputOriginInfo.create(InputOriginInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputOriginInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(InputOriginInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputOriginInfo.create(address, capacity);
    }

    public static InputOriginInfo mallocStack() {
        return InputOriginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static InputOriginInfo callocStack() {
        return InputOriginInfo.callocStack(MemoryStack.stackGet());
    }

    public static InputOriginInfo mallocStack(MemoryStack stack) {
        return InputOriginInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputOriginInfo callocStack(MemoryStack stack) {
        return InputOriginInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return InputOriginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return InputOriginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndevicePath(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEVICEPATH);
    }

    public static int ntrackedDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRACKEDDEVICEINDEX);
    }

    public static ByteBuffer nrchRenderModelComponentName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHRENDERMODELCOMPONENTNAME, 128);
    }

    public static String nrchRenderModelComponentNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)RCHRENDERMODELCOMPONENTNAME);
    }

    static {
        Struct.Layout layout = InputOriginInfo.__struct(InputOriginInfo.__member(8), InputOriginInfo.__member(4), InputOriginInfo.__array(1, 128));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEPATH = layout.offsetof(0);
        TRACKEDDEVICEINDEX = layout.offsetof(1);
        RCHRENDERMODELCOMPONENTNAME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputOriginInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected InputOriginInfo newInstance(long address) {
            return new InputOriginInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VRInputValueHandle_t")
        public long devicePath() {
            return InputOriginInfo.ndevicePath(this.address());
        }

        @NativeType(value="TrackedDeviceIndex_t")
        public int trackedDeviceIndex() {
            return InputOriginInfo.ntrackedDeviceIndex(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchRenderModelComponentName() {
            return InputOriginInfo.nrchRenderModelComponentName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchRenderModelComponentNameString() {
            return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
        }
    }
}

