/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputAnalogActionData_t")
public class InputAnalogActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int DELTAX;
    public static final int DELTAY;
    public static final int DELTAZ;
    public static final int FUPDATETIME;

    InputAnalogActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public InputAnalogActionData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), InputAnalogActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputAnalogActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputAnalogActionData.nactiveOrigin(this.address());
    }

    public float x() {
        return InputAnalogActionData.nx(this.address());
    }

    public float y() {
        return InputAnalogActionData.ny(this.address());
    }

    public float z() {
        return InputAnalogActionData.nz(this.address());
    }

    public float deltaX() {
        return InputAnalogActionData.ndeltaX(this.address());
    }

    public float deltaY() {
        return InputAnalogActionData.ndeltaY(this.address());
    }

    public float deltaZ() {
        return InputAnalogActionData.ndeltaZ(this.address());
    }

    public float fUpdateTime() {
        return InputAnalogActionData.nfUpdateTime(this.address());
    }

    public static InputAnalogActionData malloc() {
        return InputAnalogActionData.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputAnalogActionData calloc() {
        return InputAnalogActionData.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputAnalogActionData create() {
        return new InputAnalogActionData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static InputAnalogActionData create(long address) {
        return new InputAnalogActionData(address, null);
    }

    @Nullable
    public static InputAnalogActionData createSafe(long address) {
        return address == 0L ? null : InputAnalogActionData.create(address);
    }

    public static Buffer malloc(int capacity) {
        return InputAnalogActionData.create(InputAnalogActionData.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputAnalogActionData.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(InputAnalogActionData.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputAnalogActionData.create(address, capacity);
    }

    public static InputAnalogActionData mallocStack() {
        return InputAnalogActionData.mallocStack(MemoryStack.stackGet());
    }

    public static InputAnalogActionData callocStack() {
        return InputAnalogActionData.callocStack(MemoryStack.stackGet());
    }

    public static InputAnalogActionData mallocStack(MemoryStack stack) {
        return InputAnalogActionData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputAnalogActionData callocStack(MemoryStack stack) {
        return InputAnalogActionData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return InputAnalogActionData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return InputAnalogActionData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputAnalogActionData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputAnalogActionData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ACTIVEORIGIN);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static float ndeltaX(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DELTAX);
    }

    public static float ndeltaY(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DELTAY);
    }

    public static float ndeltaZ(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DELTAZ);
    }

    public static float nfUpdateTime(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FUPDATETIME);
    }

    static {
        Struct.Layout layout = InputAnalogActionData.__struct(InputAnalogActionData.__member(1), InputAnalogActionData.__member(8), InputAnalogActionData.__member(4), InputAnalogActionData.__member(4), InputAnalogActionData.__member(4), InputAnalogActionData.__member(4), InputAnalogActionData.__member(4), InputAnalogActionData.__member(4), InputAnalogActionData.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        X = layout.offsetof(2);
        Y = layout.offsetof(3);
        Z = layout.offsetof(4);
        DELTAX = layout.offsetof(5);
        DELTAY = layout.offsetof(6);
        DELTAZ = layout.offsetof(7);
        FUPDATETIME = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<InputAnalogActionData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected InputAnalogActionData newInstance(long address) {
            return new InputAnalogActionData(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputAnalogActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputAnalogActionData.nactiveOrigin(this.address());
        }

        public float x() {
            return InputAnalogActionData.nx(this.address());
        }

        public float y() {
            return InputAnalogActionData.ny(this.address());
        }

        public float z() {
            return InputAnalogActionData.nz(this.address());
        }

        public float deltaX() {
            return InputAnalogActionData.ndeltaX(this.address());
        }

        public float deltaY() {
            return InputAnalogActionData.ndeltaY(this.address());
        }

        public float deltaZ() {
            return InputAnalogActionData.ndeltaZ(this.address());
        }

        public float fUpdateTime() {
            return InputAnalogActionData.nfUpdateTime(this.address());
        }
    }
}

