/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuaternionf_t")
public class HmdQuaternionf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    HmdQuaternionf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public HmdQuaternionf(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdQuaternionf.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float w() {
        return HmdQuaternionf.nw(this.address());
    }

    public float x() {
        return HmdQuaternionf.nx(this.address());
    }

    public float y() {
        return HmdQuaternionf.ny(this.address());
    }

    public float z() {
        return HmdQuaternionf.nz(this.address());
    }

    public HmdQuaternionf w(float value) {
        HmdQuaternionf.nw(this.address(), value);
        return this;
    }

    public HmdQuaternionf x(float value) {
        HmdQuaternionf.nx(this.address(), value);
        return this;
    }

    public HmdQuaternionf y(float value) {
        HmdQuaternionf.ny(this.address(), value);
        return this;
    }

    public HmdQuaternionf z(float value) {
        HmdQuaternionf.nz(this.address(), value);
        return this;
    }

    public HmdQuaternionf set(float w, float x, float y, float z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public HmdQuaternionf set(HmdQuaternionf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdQuaternionf malloc() {
        return HmdQuaternionf.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdQuaternionf calloc() {
        return HmdQuaternionf.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdQuaternionf create() {
        return new HmdQuaternionf(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdQuaternionf create(long address) {
        return new HmdQuaternionf(address, null);
    }

    @Nullable
    public static HmdQuaternionf createSafe(long address) {
        return address == 0L ? null : HmdQuaternionf.create(address);
    }

    public static Buffer malloc(int capacity) {
        return HmdQuaternionf.create(HmdQuaternionf.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdQuaternionf.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(HmdQuaternionf.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdQuaternionf.create(address, capacity);
    }

    public static HmdQuaternionf mallocStack() {
        return HmdQuaternionf.mallocStack(MemoryStack.stackGet());
    }

    public static HmdQuaternionf callocStack() {
        return HmdQuaternionf.callocStack(MemoryStack.stackGet());
    }

    public static HmdQuaternionf mallocStack(MemoryStack stack) {
        return HmdQuaternionf.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdQuaternionf callocStack(MemoryStack stack) {
        return HmdQuaternionf.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdQuaternionf.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdQuaternionf.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuaternionf.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuaternionf.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = HmdQuaternionf.__struct(HmdQuaternionf.__member(4), HmdQuaternionf.__member(4), HmdQuaternionf.__member(4), HmdQuaternionf.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdQuaternionf, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdQuaternionf newInstance(long address) {
            return new HmdQuaternionf(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float w() {
            return HmdQuaternionf.nw(this.address());
        }

        public float x() {
            return HmdQuaternionf.nx(this.address());
        }

        public float y() {
            return HmdQuaternionf.ny(this.address());
        }

        public float z() {
            return HmdQuaternionf.nz(this.address());
        }

        public Buffer w(float value) {
            HmdQuaternionf.nw(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            HmdQuaternionf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            HmdQuaternionf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            HmdQuaternionf.nz(this.address(), value);
            return this;
        }
    }
}

