/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdMatrix34_t")
public class HmdMatrix34
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    HmdMatrix34(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public HmdMatrix34(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdMatrix34.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[12]")
    public FloatBuffer m() {
        return HmdMatrix34.nm(this.address());
    }

    public float m(int index) {
        return HmdMatrix34.nm(this.address(), index);
    }

    public HmdMatrix34 m(@NativeType(value="float[12]") FloatBuffer value) {
        HmdMatrix34.nm(this.address(), value);
        return this;
    }

    public HmdMatrix34 m(int index, float value) {
        HmdMatrix34.nm(this.address(), index, value);
        return this;
    }

    public HmdMatrix34 set(HmdMatrix34 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdMatrix34 malloc() {
        return HmdMatrix34.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdMatrix34 calloc() {
        return HmdMatrix34.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdMatrix34 create() {
        return new HmdMatrix34(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdMatrix34 create(long address) {
        return new HmdMatrix34(address, null);
    }

    @Nullable
    public static HmdMatrix34 createSafe(long address) {
        return address == 0L ? null : HmdMatrix34.create(address);
    }

    public static Buffer malloc(int capacity) {
        return HmdMatrix34.create(HmdMatrix34.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdMatrix34.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(HmdMatrix34.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdMatrix34.create(address, capacity);
    }

    public static HmdMatrix34 mallocStack() {
        return HmdMatrix34.mallocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix34 callocStack() {
        return HmdMatrix34.callocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix34 mallocStack(MemoryStack stack) {
        return HmdMatrix34.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdMatrix34 callocStack(MemoryStack stack) {
        return HmdMatrix34.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdMatrix34.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdMatrix34.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdMatrix34.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdMatrix34.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nm(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 12);
    }

    public static float nm(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + Checks.check(index, 12) * 4L);
    }

    public static void nm(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 12);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nm(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + Checks.check(index, 12) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdMatrix34.__struct(HmdMatrix34.__array(4, 12));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdMatrix34, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdMatrix34 newInstance(long address) {
            return new HmdMatrix34(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float[12]")
        public FloatBuffer m() {
            return HmdMatrix34.nm(this.address());
        }

        public float m(int index) {
            return HmdMatrix34.nm(this.address(), index);
        }

        public Buffer m(@NativeType(value="float[12]") FloatBuffer value) {
            HmdMatrix34.nm(this.address(), value);
            return this;
        }

        public Buffer m(int index, float value) {
            HmdMatrix34.nm(this.address(), index, value);
            return this;
        }
    }
}

