/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageKHRCallbackI;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT_KHR = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_KHR = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH_KHR = 33389;
    public static final int GL_MAX_LABEL_LENGTH_KHR = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_KHR = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_KHR = 33349;
    public static final int GL_DEBUG_SOURCE_API_KHR = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_KHR = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_KHR = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_KHR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_KHR = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_KHR = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_KHR = 33361;
    public static final int GL_DEBUG_TYPE_MARKER_KHR = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP_KHR = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP_KHR = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH_KHR = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_KHR = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_KHR = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 33387;
    public static final int GL_STACK_UNDERFLOW_KHR = 1284;
    public static final int GL_STACK_OVERFLOW_KHR = 1283;
    public static final int GL_BUFFER_KHR = 33504;
    public static final int GL_SHADER_KHR = 33505;
    public static final int GL_PROGRAM_KHR = 33506;
    public static final int GL_QUERY_KHR = 33507;
    public static final int GL_PROGRAM_PIPELINE_KHR = 33508;
    public static final int GL_SAMPLER_KHR = 33510;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDebugMessageControlKHR, caps.glDebugMessageInsertKHR, caps.glDebugMessageCallbackKHR, caps.glGetDebugMessageLogKHR, caps.glGetPointervKHR, caps.glPushDebugGroupKHR, caps.glPopDebugGroupKHR, caps.glObjectLabelKHR, caps.glGetObjectLabelKHR, caps.glObjectPtrLabelKHR, caps.glGetObjectPtrLabelKHR);
    }

    public static native void nglDebugMessageControlKHR(int var0, int var1, int var2, int var3, long var4, boolean var6);

    public static void glDebugMessageControlKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLenum") int type, @NativeType(value="GLenum") int severity, @Nullable @NativeType(value="GLuint const *") IntBuffer ids, @NativeType(value="GLboolean") boolean enabled) {
        KHRDebug.nglDebugMessageControlKHR(source, type, severity, Checks.remainingSafe(ids), MemoryUtil.memAddressSafe(ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControlKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLenum") int type, @NativeType(value="GLenum") int severity, @Nullable @NativeType(value="GLuint const *") int id, @NativeType(value="GLboolean") boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            KHRDebug.nglDebugMessageControlKHR(source, type, severity, 1, MemoryUtil.memAddress(ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageInsertKHR(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDebugMessageInsertKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLenum") int type, @NativeType(value="GLuint") int id, @NativeType(value="GLenum") int severity, @NativeType(value="GLchar const *") ByteBuffer message) {
        KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLenum") int type, @NativeType(value="GLuint") int id, @NativeType(value="GLenum") int severity, @NativeType(value="GLchar const *") CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, messageEncoded.remaining(), MemoryUtil.memAddress(messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageCallbackKHR(long var0, long var2);

    public static void glDebugMessageCallbackKHR(@Nullable @NativeType(value="GLDEBUGPROCKHR") GLDebugMessageKHRCallbackI callback, @NativeType(value="void const *") long userParam) {
        KHRDebug.nglDebugMessageCallbackKHR(MemoryUtil.memAddressSafe(callback), userParam);
    }

    public static native int nglGetDebugMessageLogKHR(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="GLuint")
    public static int glGetDebugMessageLogKHR(@NativeType(value="GLuint") int count, @Nullable @NativeType(value="GLenum *") IntBuffer sources, @Nullable @NativeType(value="GLenum *") IntBuffer types, @Nullable @NativeType(value="GLuint *") IntBuffer ids, @Nullable @NativeType(value="GLenum *") IntBuffer severities, @Nullable @NativeType(value="GLsizei *") IntBuffer lengths, @Nullable @NativeType(value="GLchar *") ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sources, count);
            Checks.checkSafe((Buffer)types, count);
            Checks.checkSafe((Buffer)ids, count);
            Checks.checkSafe((Buffer)severities, count);
            Checks.checkSafe((Buffer)lengths, count);
        }
        return KHRDebug.nglGetDebugMessageLogKHR(count, Checks.remainingSafe(messageLog), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static native void nglGetPointervKHR(int var0, long var1);

    public static void glGetPointervKHR(@NativeType(value="GLenum") int pname, @NativeType(value="void **") PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static long glGetPointerKHR(@NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglPushDebugGroupKHR(int var0, int var1, int var2, long var3);

    public static void glPushDebugGroupKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLuint") int id, @NativeType(value="GLchar const *") ByteBuffer message) {
        KHRDebug.nglPushDebugGroupKHR(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushDebugGroupKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLuint") int id, @NativeType(value="GLchar const *") CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            KHRDebug.nglPushDebugGroupKHR(source, id, messageEncoded.remaining(), MemoryUtil.memAddress(messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glPopDebugGroupKHR();

    public static native void nglObjectLabelKHR(int var0, int var1, int var2, long var3);

    public static void glObjectLabelKHR(@NativeType(value="GLenum") int identifier, @NativeType(value="GLuint") int name, @NativeType(value="GLchar const *") ByteBuffer label) {
        KHRDebug.nglObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectLabelKHR(@NativeType(value="GLenum") int identifier, @NativeType(value="GLuint") int name, @NativeType(value="GLchar const *") CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            KHRDebug.nglObjectLabelKHR(identifier, name, labelEncoded.remaining(), MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectLabelKHR(int var0, int var1, int var2, long var3, long var5);

    public static void glGetObjectLabelKHR(@NativeType(value="GLenum") int identifier, @NativeType(value="GLuint") int name, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetObjectLabelKHR(@NativeType(value="GLenum") int identifier, @NativeType(value="GLuint") int name, @NativeType(value="GLsizei") int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetObjectLabelKHR(@NativeType(value="GLenum") int identifier, @NativeType(value="GLuint") int name) {
        return KHRDebug.glGetObjectLabelKHR(identifier, name, GLES20.glGetInteger(33512));
    }

    public static native void nglObjectPtrLabelKHR(long var0, int var2, long var3);

    public static void glObjectPtrLabelKHR(@NativeType(value="void *") long ptr, @NativeType(value="GLchar const *") ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
        }
        KHRDebug.nglObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectPtrLabelKHR(@NativeType(value="void *") long ptr, @NativeType(value="GLchar const *") CharSequence label) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            KHRDebug.nglObjectPtrLabelKHR(ptr, labelEncoded.remaining(), MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectPtrLabelKHR(long var0, int var2, long var3, long var5);

    public static void glGetObjectPtrLabelKHR(@NativeType(value="void *") long ptr, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
            Checks.checkSafe((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetObjectPtrLabelKHR(@NativeType(value="void *") long ptr, @NativeType(value="GLsizei") int bufSize) {
        if (Checks.CHECKS) {
            Checks.check(ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetObjectPtrLabelKHR(@NativeType(value="void *") long ptr) {
        return KHRDebug.glGetObjectPtrLabelKHR(ptr, GLES20.glGetInteger(33512));
    }

    public static void glDebugMessageControlKHR(@NativeType(value="GLenum") int source, @NativeType(value="GLenum") int type, @NativeType(value="GLenum") int severity, @Nullable @NativeType(value="GLuint const *") int[] ids, @NativeType(value="GLboolean") boolean enabled) {
        long __functionAddress = GLES.getICD().glDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, Checks.lengthSafe(ids), ids, enabled);
    }

    @NativeType(value="GLuint")
    public static int glGetDebugMessageLogKHR(@NativeType(value="GLuint") int count, @Nullable @NativeType(value="GLenum *") int[] sources, @Nullable @NativeType(value="GLenum *") int[] types, @Nullable @NativeType(value="GLuint *") int[] ids, @Nullable @NativeType(value="GLenum *") int[] severities, @Nullable @NativeType(value="GLsizei *") int[] lengths, @Nullable @NativeType(value="GLchar *") ByteBuffer messageLog) {
        long __functionAddress = GLES.getICD().glGetDebugMessageLogKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(sources, count);
            Checks.checkSafe(types, count);
            Checks.checkSafe(ids, count);
            Checks.checkSafe(severities, count);
            Checks.checkSafe(lengths, count);
        }
        return JNI.callPPPPPPI(__functionAddress, count, Checks.remainingSafe(messageLog), sources, types, ids, severities, lengths, MemoryUtil.memAddressSafe(messageLog));
    }

    public static void glGetObjectLabelKHR(@NativeType(value="GLenum") int identifier, @NativeType(value="GLuint") int name, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectLabelKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, identifier, name, label.remaining(), length, MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabelKHR(@NativeType(value="void *") long ptr, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ptr);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPPV(__functionAddress, ptr, label.remaining(), length, MemoryUtil.memAddress(label));
    }

    static {
        GLES.initialize();
    }
}

