/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTDiscardFramebuffer {
    public static final int GL_COLOR_EXT = 6144;
    public static final int GL_DEPTH_EXT = 6145;
    public static final int GL_STENCIL_EXT = 6146;

    protected EXTDiscardFramebuffer() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDiscardFramebufferEXT);
    }

    public static native void nglDiscardFramebufferEXT(int var0, int var1, long var2);

    public static void glDiscardFramebufferEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLenum const *") IntBuffer attachments) {
        EXTDiscardFramebuffer.nglDiscardFramebufferEXT(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDiscardFramebufferEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLenum const *") int attachment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer attachments = stack.ints(attachment);
            EXTDiscardFramebuffer.nglDiscardFramebufferEXT(target, 1, MemoryUtil.memAddress(attachments));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDiscardFramebufferEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLenum const *") int[] attachments) {
        long __functionAddress = GLES.getICD().glDiscardFramebufferEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, attachments.length, attachments);
    }

    static {
        GLES.initialize();
    }
}

