/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class QCOMEXTHostPtr {
    public static final int CL_DEVICE_EXT_MEM_PADDING_IN_BYTES_QCOM = 16544;
    public static final int CL_DEVICE_PAGE_SIZE_QCOM = 16545;
    public static final int CL_MEM_EXT_HOST_PTR_QCOM = 0x20000000;
    public static final int CL_MEM_HOST_UNCACHED_QCOM = 16548;
    public static final int CL_MEM_HOST_WRITEBACK_QCOM = 16549;
    public static final int CL_MEM_HOST_WRITETHROUGH_QCOM = 16550;
    public static final int CL_MEM_HOST_WRITE_COMBINING_QCOM = 16551;
    public static final int CL_IMAGE_ROW_ALIGNMENT_QCOM = 16546;
    public static final int CL_IMAGE_SLICE_ALIGNMENT_QCOM = 16547;

    protected QCOMEXTHostPtr() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clGetDeviceImageInfoQCOM);
    }

    public static int nclGetDeviceImageInfoQCOM(long device, long image_width, long image_height, long image_format, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceImageInfoQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPPPPPPI(__functionAddress, device, image_width, image_height, image_format, param_name, param_value_size, param_value, param_value_size_ret);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceImageInfoQCOM(@NativeType(value="cl_device_id") long device, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_pitch_info_qcom") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return QCOMEXTHostPtr.nclGetDeviceImageInfoQCOM(device, image_width, image_height, image_format.address(), param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceImageInfoQCOM(@NativeType(value="cl_device_id") long device, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_pitch_info_qcom") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return QCOMEXTHostPtr.nclGetDeviceImageInfoQCOM(device, image_width, image_height, image_format.address(), param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceImageInfoQCOM(@NativeType(value="cl_device_id") long device, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_pitch_info_qcom") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceImageInfoQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPPPPI(__functionAddress, device, image_width, image_height, image_format.address(), param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

